<?php

switch( $_REQUEST['action'] ) {
			
	# Admin or Group Login
	case 'login':
	
		// Password length check
		if( strlen($_POST['auth_pass']) < 3 ) {
			
			$_SESSION['MSG']['text'] = 'Authentication failed. Invalid password?';
		
		} else {
		
			$pass_hash = hash('sha256', $_POST['auth_pass']);
			
			// TerraTool only: Get real password from database. Don't rely on cached one.
			if( $config['isttmap'] ) {
				$result = $cdb->query( "SELECT admin_pass FROM {$config['table_c']} WHERE ID = '$livemap_id'", FALSE );
				$config['admin_pass'] = $result['admin_pass'];
				$_SESSION['config']['admin_pass'] = $result['admin_pass'];
			}
				
			// Admin Login
			if( $pass_hash === $config['admin_pass'] ) {
				$_SESSION['login'] = TRUE;
				$mygroup = new Group( 0, 'Admin', 0 );
			} else {
				// User Group Login
				foreach($groups AS $group) {
					if( $pass_hash === $group['password'] ) {
						$_SESSION['login'] = TRUE;
						$mygroup = new Group( $group['ID'], $group['name'], intval($group['privileges']) );
					}
				} 
			}
			
			// Failed auth
			if( ! $_SESSION['login'] ) $_SESSION['MSG']['text'] = 'Authentication failed. Invalid password?';
			// Successful auth
			else $_SESSION['mygroup'] = serialize($mygroup);
			
		}
		
	break;
	
	
	# Logout
	case 'logout':
	
		session_destroy();
		header("Location: index.php?livemap_id=$livemap_id");
		die;
		
	break;
	
	
	# Steam User Login
	case 'SteamAuth':
	
		$redirect = "index.php?livemap_id=$livemap_id&s=guildman";
		require_once('includes/libs/openid.php');
	
		try {
		
			$openid = new LightOpenID($_SERVER['HTTP_HOST']);
			
			// Initiate auth
			if( ! $openid->mode ) {
				
				$openid->identity = 'https://steamcommunity.com/openid';
				header('Location: ' . $openid->authUrl());
				die;
				
			} 
			
			// Auth canceld
			if( $openid->mode === 'cancel' ) error_redirect($redirect, "Steam authentication was canceled.");

			// Auth success
			if( $openid->validate() )  {
				
				$steamid = explode('/', $openid->identity);
				$steamid = end($steamid);
				
				if( count($server->get_steam_characters($steamid)) < 1 ) error_redirect($redirect, "You have no characters on this server.");
				
				// Remember Login?
				if( isSet($_GET['remember']) ) {
					$characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
					$length = strlen($characters);
					$token = '';
					for( $i = 0; $i < 32; $i++ ) $token .= $characters[mt_rand(0, $length - 1)];
					$cdb->query( "INSERT INTO {$config['table_s']} (SteamID, Token, Expires) VALUES ('$steamid', '$token', DATE_ADD(NOW(), INTERVAL 14 DAY))" );
					$cdb->query( "DELETE FROM {$config['table_s']} WHERE Expires < NOW()" );
					$cookie = array($steamid, $token);
					setcookie('SteamAuth', serialize($cookie), time()+3600*24*14);				
				}

				$_SESSION['SteamAuth'] = array( 'steam_id' => $steamid );
				
				success_redirect($redirect, "Successfully logged in.");
				
			}
			
		} catch(ErrorException $e) {
			
			error_redirect($redirect, "An error occoured while trying to contact the Steam API: " . $e->getMessage() );
			
		}
		
		// Fail
		error_redirect($redirect, "An error occoured during Steam authentication.");

	break;
	
	
	# Login through TTmod security token (ingame browser)
	case 'GuildGUI':
	
		if( ! isSet($_GET['Token']) || strlen($_GET['Token']) !== 64 ) die("An error occoured. Couldn't authenticate you.");

		$token = $cdb->esc($_GET['Token']);
		
		$details = $server->get_token_details($token);
		
		if( ! $details ) die("An error occoured. Unable to authenticate you.");
		
		$_SESSION['SteamAuth'] = array( 'steam_id' => $details['SteamID'] );
		$_SESSION['InGame'] = TRUE;
		$_SESSION['CharID'] = intval($details['CharID']);
		
		$redirect = "index.php?livemap_id=$livemap_id&s=guildman";
		header("Location: $redirect");
		die;

	break;
	
	
	# Steam User Logout
	case 'SteamLogout':

		session_destroy();
		setcookie('SteamAuth', '', time() - 3600);
		header("Location: index.php?livemap_id=$livemap_id");
	
	break;
	
	
	# Change Config
	case 'ChangeConfig':
		
		$redirect = "index.php?livemap_id=$livemap_id&s=conf";
		
		// Check permission
		if( ! $mygroup->admin ) error_redirect($redirect);
		
		// Check config type
		if( ! isSet($_POST['config']) || ! in_array($_POST['config'], array('general','appearance')) ) error_redirect($redirect);
		$redirect .= '#tab-' . $_POST['config'];
		
		switch( $_POST['config'] ) {
			
			// General Configuration
			case 'general':
			
				// Check input is set
				if( ! isSet($_POST['title'], $_POST['homepage'], $_POST['discord'], $_POST['teamspeak'], $_POST['restarts'], $_POST['language'], $_POST['daycycle'], $_POST['timezone'], $_POST['guildmanager']) ) error_redirect($redirect);
				
				// Evaluate input
				$language = $_POST['language'];
				$title    = trim($cdb->esc($_POST['title']));
				$homepage = trim($cdb->esc($_POST['homepage']));
				$discord  = trim($cdb->esc($_POST['discord']));
				$teamspeak= trim($cdb->esc($_POST['teamspeak']));
				$restarts = trim($_POST['restarts']);
				$daycycle = floatval($_POST['daycycle']);
				$timezone = $_POST['timezone'];
				$guildman = intval($_POST['guildmanager']);
				
				// Check input plausibility
				if( strlen($restarts) > 0 ) {
					$errms = 'Invalid timestamp for server restarts. Please use 24-hour HH:MM format, such as 03:00 or 21:30. Seperate multiple times using a blank space in between.';
					$times = explode(' ', $restarts);
					foreach( $times AS $time ) {
						if( preg_match("/^\d\d:\d\d$/", $time) !== 1 ) error_redirect($redirect, $errms);
						$hourmin = explode(':', $time);
						if( count($hourmin) !== 2 || intval($hourmin[0]) < 0 || intval($hourmin[0]) > 23 || intval($hourmin[1]) < 0 || intval($hourmin[1]) > 59 ) error_redirect($redirect, $errms);
					}
				}
				if( strlen($homepage) > 0 && filter_var($homepage, FILTER_VALIDATE_URL) === FALSE ) {
					$homepage = "http://$homepage";
					if( filter_var($homepage, FILTER_VALIDATE_URL) === FALSE ) error_redirect($redirect, 'Invalid homepage address!');
				}
				if( ! in_array( $language, array_keys(Livemap::$languages) ) ) error_redirect($redirect);
				if( strlen($title) < 5 ) error_redirect($redirect, 'Server name was too short. Please use at least 5 characters.');
				if( strlen($restarts) > 50 ) error_redirect($redirect, 'Too many restart timestamps');
				if( ! in_array($timezone, timezone_identifiers_list()) ) error_redirect($redirect, 'Invalid timezone.');
				if( $daycycle < 1 || $daycycle > 24 ) error_redirect($redirect, "dayCycle setting is out of range. Please set dayCycle from min 1.0 to max 24.0.");
				
				// Hosted livemap only: Check file uploads
				if( $config['isttmap'] ) {
	
					foreach( $_FILES AS $name => $file ) {
						
						// Skip if name is invalid or no file was selected
						if( $file['error'] === UPLOAD_ERR_NO_FILE ) continue;
						// Upload error check
						if( $file['error'] !== UPLOAD_ERR_OK ) error_redirect($redirect, "An error occoured during file upload (Error code {$file['error']}). Try again?");
						// Filesize check
						if( $file['error'] === UPLOAD_ERR_FORM_SIZE || $file['error'] === UPLOAD_ERR_INI_SIZE ) error_redirect($redirect, "The maximum filesize was exceeded.");
						
						switch( $name ) {
							
							case 'weather_xml':
							
								$errms = "Invalid weather configuration XML file.";
							
								// Check filesize and mime type
								if( $file['size'] < 1024*5 || $file['size'] > 1024*50 || ($file['type'] !== 'application/xml' && $file['type'] !== 'text/xml') ) error_redirect($redirect, $errms);

								// Basic XML file check
								try {
									$xml = simplexml_load_file($file['tmp_name']);
									for( $day = 0; $day < 365; $day++ ) if( intval($xml->day[$day]['id']->__toString()) !== $day ) error_redirect($redirect, $errms);
								} catch(Exception $e) {
									error_redirect($redirect, $errms);
								}
								
								// Save file to disk
								if( ! $xml->asXML("weather/{$livemap_id}_weather.xml") ) error_redirect($redirect, "Unable to save weather XML file on server. Please try again later.");
								
							break;
							
						}
						
					}
					
				}
				
				// Update database and redirect with force_reload
				$cdb->query( "UPDATE {$config['table_c']} SET title = '$title', homepage = '$homepage', discord = '$discord', teamspeak = '$teamspeak', language = '$language', daycycle = '$daycycle', timezone = '$timezone', restarts = '$restarts', guildmanager = '$guildman' WHERE ID = '$livemap_id'" );
				Livemap::log_action('config_general');
				$_SESSION['force_reload'] = TRUE;
				success_redirect( $redirect, "Livemap configuration was updated successfully." );
			
			// Appearance Configuration
			case 'appearance':
			
				// Check input is set
				if( ! isSet($_POST['color_bg'], $_POST['color_bg'], $_POST['color_label'], $_POST['color_claim_t1'], $_POST['color_claim_t2'], $_POST['color_claim_t3'], $_POST['color_claim_t4'], $_POST['style_claim'], $_POST['style_tooltip'], $_POST['width_claim'],  $_POST['font_claimdetail'],  $_POST['font_claimlabel']) ) error_redirect($redirect);
			
				// Evaluate input
				$alt_map  = isSet($_POST['alt_map']) ? 1 : 0;
				$c_bg	  = $_POST['color_bg'];
				$c_label  = isSet($_POST['show_labels']) && $_POST['show_labels'] === '1' ? $_POST['color_label'] : 'ZZZZZZ';
				$s_claim  = $_POST['style_claim'];
				$w_claim  = intval($_POST['width_claim']);
				$s_tooltip= $_POST['style_tooltip'];
				$f_detail = $_POST['font_claimdetail'];
				$f_label  = $_POST['font_claimlabel'];
				$c_claim_t1	= $_POST['color_claim_t1'];
				$c_claim_t2	= $_POST['color_claim_t2'];
				$c_claim_t3	= $_POST['color_claim_t3'];
				$c_claim_t4	= $_POST['color_claim_t4'];
				
				// Check input plausibility
				$valid_fonts = Livemap::get_font_names();
				if( ! in_array($f_detail, $valid_fonts) || ! in_array($f_label, $valid_fonts) ) error_redirect($redirect, 'Invalid font type');
				if( preg_match('/^[a-f0-9]{6}$/i', $c_bg)    !== 1 ) error_redirect($redirect, 'Invalid hex color code for background');
				if( preg_match('/^[a-f0-9]{6}$/i', $c_claim_t1) !== 1 ) error_redirect($redirect, 'Invalid hex color code for claims');
				if( preg_match('/^[a-f0-9]{6}$/i', $c_claim_t2) !== 1 ) error_redirect($redirect, 'Invalid hex color code for claims');
				if( preg_match('/^[a-f0-9]{6}$/i', $c_claim_t3) !== 1 ) error_redirect($redirect, 'Invalid hex color code for claims');
				if( preg_match('/^[a-f0-9]{6}$/i', $c_claim_t4) !== 1 ) error_redirect($redirect, 'Invalid hex color code for claims');
				if( preg_match('/^[a-f0-9]{6}$/i', $c_label) !== 1 && $c_label !== 'ZZZZZZ' ) error_redirect($redirect, 'Invalid hex color code for claim labels');
				if( ! in_array($s_claim, array('solid', 'dotted', 'dashed', 'double') ) ) error_redirect($redirect);
				if( ! in_array($s_tooltip, array('standard', 'dark', 'alert', 'glass') ) ) error_redirect($redirect);
				if( $w_claim < 1 || $w_claim > 5 ) error_redirect($redirect);
				
				// Hosted livemap only: Check file uploads
				if( $config['isttmap'] ) {
	
					foreach( $_FILES AS $name => $file ) {
						
						// Skip if name is invalid or no file was selected
						if( $file['error'] === UPLOAD_ERR_NO_FILE ) continue;
						// Upload error check
						if( $file['error'] !== UPLOAD_ERR_OK ) error_redirect($redirect, "An error occoured during file upload (Error code {$file['error']}). Try again?");
						// Filesize check
						if( $file['error'] === UPLOAD_ERR_FORM_SIZE || $file['error'] === UPLOAD_ERR_INI_SIZE ) error_redirect($redirect, "The maximum filesize was exceeded.");
						
						switch( $name ) {
							
							case 'mapfile_default':
							case 'mapfile_alternative':
						
								// Filesize check
								if( $file['size'] > 1024*1024*8 ) error_redirect($redirect, "The maximum filesize of 8 MB was exceeded.");
								
								// Filetype check
								$valid_mime = array('image/png', 'image/jpg', 'image/jpeg');
								if( ! in_array($file['type'], $valid_mime) ) error_redirect($redirect, "Invalid image filetype. You can upload JPG, JPEG or PNG files only.");
								
								// Image dimension check via getimagesize
								$imginfo = getimagesize( $file['tmp_name'] );
								if( $imginfo === FALSE ) error_redirect($redirect, "Unable to open image. Please check format.");
								if( $imginfo[0] !== 1533 || $imginfo[1] !== 1533 ) error_redirect($redirect, "Map image needs to be exactly 1533x1533 pixel. Please scale your image before uploading if necessary.");
								if( 	$imginfo[2] === IMAGETYPE_JPEG ) $image = imagecreatefromjpeg($file['tmp_name']);
								elseif( $imginfo[2] === IMAGETYPE_PNG  ) $image = imagecreatefrompng($file['tmp_name']);
								else error_redirect($redirect, "Invalid image filetype. You can upload JPG, JPEG or PNG files only.");	
								
								// Convert image and save
								$filename = $name === 'mapfile_default' ? "{$livemap_id}_default.jpg" : "{$livemap_id}_alternative.jpg";
								if( ! imagejpeg($image, "{$config['path']}/maps/user/$filename", 82) ) error_redirect( $redirect, "An error occoured during file upload" );
								imagedestroy($image);
								$cdb->query( "UPDATE {$config['table_c']} SET file_revision = file_revision + 1 WHERE ID = '$livemap_id'" );
							
							break;
							
						}
						
					}
					
				}
				
				// Update database and redirect with force_reload
				$cdb->query( "UPDATE {$config['table_c']} SET alt_map = $alt_map, color_bg = '$c_bg', color_claim_t1 = '$c_claim_t1', color_claim_t2 = '$c_claim_t2', color_claim_t3 = '$c_claim_t3', color_claim_t4 = '$c_claim_t4', color_label = '$c_label', style_claim = '$s_claim', style_tooltip = '$s_tooltip', width_claim = '$w_claim', font_claimlabel = '$f_label', font_claimdetail = '$f_detail' WHERE ID = '$livemap_id'" );
				Livemap::log_action('config_appearance');
				$_SESSION['force_reload'] = TRUE;
				success_redirect( $redirect, "Livemap configuration was updated successfully." );
				
			break;	
			
		}
		
	break;
	
	
	# View phpinfo page
	case 'PHPinfo':
	
		// Check permission
		if( ! $mygroup->admin || $config['isttmap'] ) error_redirect("index.php?livemap_id=$livemap_id");
		
		// Render phpinfo and kill process
		phpinfo();
		die;
		
	break;
	
	
	# Edit a group
	case 'ChangeGroup':
		
		$group_id = isSet($_POST['group_id']) ? intval($_POST['group_id']) : 0;
		$redirect = "index.php?livemap_id=$livemap_id&s=group&id=$group_id";
		
		// Check permission
		if( ! $mygroup->admin ) error_redirect($redirect);
		
		// Load group info from database
		$groupinfo = $cdb->query( "SELECT * FROM {$config['table_g']} WHERE ID = '$group_id'", FALSE );
				
		// Get values
		$is_protected = ! isSet($_POST['name']);
		$is_new = empty($groupinfo);
		$name = $is_protected && ! $is_new ? $cdb->esc($groupinfo['name']) : $cdb->esc($_POST['name']);
		$enable_login = isSet($_POST['login_enable']);
		$enable_tags  = isSet($_POST['tag_enable']);
		$tag_color = $enable_tags ? $cdb->esc($_POST['tag_color']) : 'CCCCFF';
		$tag_name  = $enable_tags ? $cdb->esc($_POST['tag_name']) : '';
		$privileges = isSet($_POST['privileges']) ? $_POST['privileges'] : array();
		$members  = isSet($_POST['members']) ? $_POST['members'] : array();
		$password = isSet($_POST['login_pw']) ? $_POST['login_pw'] : '';
		
		// Check errors
		if( ! isSet($_POST['group_id']) ) error_redirect($redirect);
		if( $is_protected && $is_new ) error_redirect($redirect);
		if( strlen($name) < 2 ) error_redirect( $redirect, "Group name is too short (min 2 characters)." );
		foreach( $members AS $member ) if( ! is_numeric($member) || intval($member) === 0 ) error_redirect( $redirect, "Invalid character ID in member list." );
		foreach( $privileges AS $priv ) if( ! in_array($priv, array_keys($mygroup->privileges)) ) error_redirect( $redirect, "Invalid key in privilege list." );
		if( preg_match("/^[A-Fa-f0-9]{6}$/i", $tag_color) !== 1 ) error_redirect( $redirect, "Invalid tag color code." );
		if( $enable_tags && strlen($tag_name) > 3 ) error_redirect( $redirect, "Tag name is too long (max 3 characters)." );
		if( $enable_tags && strlen($tag_name) < 1 ) error_redirect( $redirect, "Member tagging is active but tag name is empty. Please enter a tag name." );
		if( $enable_login && strlen($password) < 5 && strlen($password) > 0 ) error_redirect( $redirect, "Password is too short. Please use a minimum of 5 characters." );
		if( $enable_login && strlen($password) === 0 && $is_new ) error_redirect( $redirect, "Password is too short. Please use a minimum of 5 characters." );
		if( $enable_login && strlen($password) === 0 && ! $is_new ) if( strlen($groupinfo['password']) === 0 ) error_redirect( $redirect, "Password is too short. Please use a minimum of 5 characters." );
		
		// Prepare database update
		$g = new Group( $group_id, $name, 0 );
		foreach( $privileges AS $priv ) $g->privileges[$priv] = TRUE;
		$bitmask = $g->generate_bitmask();
		$members_csv = implode(',', $members);
		$password = $enable_login && strlen($password) > 0 ? hash('sha256', $password) : $groupinfo['password'];
		$password = $enable_login ? $password : '';
		
		// Check double passwords
		if( strlen($password) > 0 ) {
			// Other groups
			foreach( $groups AS $group ) {
				if( intval($group['ID']) !== $group_id && $password === $group['password'] ) error_redirect($redirect, "This password is already used for group: " . htmlspecialchars($group['name']) );
			}
			// Admin pass
			if( $config['admin_pass'] === $password ) error_redirect($redirect, "This password is already used for admin login.");
		}
		
		if( $is_new ) {
			$cdb->query( "INSERT INTO {$config['table_g']} (livemap_id, name, tag, tag_color, password, privileges, members_csv) VALUES ('$livemap_id', '$name', '$tag_name', '$tag_color', '$password', '$bitmask', '$members_csv')" );
			Livemap::log_action('group_add', $name);
		} else {
			$cdb->query( "UPDATE {$config['table_g']} SET name = '$name', tag = '$tag_name', tag_color = '$tag_color', password = '$password', privileges = '$bitmask', members_csv = '$members_csv' WHERE ID = '$group_id'" );
			Livemap::log_action('group_edit', $name);
		}
		
		$_SESSION['force_reload'] = TRUE;
		success_redirect( "index.php?livemap_id=$livemap_id&s=conf#tab-groups", "Group configuration was saved successfully." );
		
	break;
	
	
	# Delete a group
	case 'DeleteGroup':
	
		$group_id = isSet($_GET['id']) ? intval($_GET['id']) : 0;
		$redirect = "index.php?livemap_id=$livemap_id&s=conf#tab-groups";
		
		// user is admin?
		if( ! $mygroup->admin ) error_redirect($redirect);

		// Group exists?
		$groupinfo = $cdb->query( "SELECT name FROM {$config['table_g']} WHERE livemap_id = '$livemap_id' AND ID = '$group_id'", FALSE );
		if( ! $groupinfo ) error_redirect($redirect);
		
		// Delete
		$cdb->query( "DELETE FROM {$config['table_g']} WHERE ID = '$group_id'" );
		Livemap::log_action('group_delete', $groupinfo['name']);
		
		$_SESSION['force_reload'] = TRUE;
		success_redirect($redirect, "Group <b>" . htmlspecialchars($groupinfo['name']) . "</b> was deleted.");		
	
	break;
	
	
	# Call outsourced modules
	case 'RCON':		require_once('includes/rcon.handler.php');		break;
	case 'CHMAN': 		require_once('includes/chman.handler.php');		break;
	case 'GUILDMAN': 	require_once('includes/guildman.handler.php');	break;
	
}
		
?>