<?php
	
	function hex2rgb($hex) {
		
	   $hex = str_replace("#", "", $hex);

	   if(strlen($hex) == 3) {
		  $r = hexdec(substr($hex,0,1).substr($hex,0,1));
		  $g = hexdec(substr($hex,1,1).substr($hex,1,1));
		  $b = hexdec(substr($hex,2,1).substr($hex,2,1));
	   } else {
		  $r = hexdec(substr($hex,0,2));
		  $g = hexdec(substr($hex,2,2));
		  $b = hexdec(substr($hex,4,2));
	   }
	   
	   $rgb = array($r, $g, $b);
	   return implode(",", $rgb);
	   
	}
	
	#######################################################################################################
	
	function center_guild_label( $n, $d ) {
		
		if( $d > 100 ) {
			$center = TRUE;
		}		
		elseif( $d > 90 ) {
			$center = TRUE;
			$words = str_word_count($n, 1);
			foreach( $words AS $word ) {
				if( strlen($word) > 9 ) $center = FALSE;
			}
		} else {
			$center = FALSE;
		}
		
		return $center;
	}
	
	#######################################################################################################
	
	function simple_select( $options, $selected_option = NULL ) {
		
		$output = array();
		foreach($options AS $option) {
			$selected = $option === $selected_option ? TRUE : FALSE;
			$output[] = array( 'name' => $option, 'selected' => $selected );
		}
		return $output;
		
	}
	
	#######################################################################################################
	
	function error_redirect( $addr, $text = 'An unknown error occoured.' ) {
		$_SESSION['MSG'] = array(
			'type' => 0,
			'text' => $text
		);
		header( "Location: $addr" );
		die;
	}

	function success_redirect( $addr, $text = NULL ) {
		if( $text !== NULL ) {
			$_SESSION['MSG'] = array(
				'type' => 1,
				'text' => $text
			);
		}
		header( "Location: $addr" );
		die;
	}
	
	#######################################################################################################
	
	function debug( $input ) {
		echo"<pre>"; 
		var_dump($input); 
		echo"</pre>";
		die;
	}
	
?>