<?php

# Dependency: class MySQL
#			  $_SESSION['config']
#			  $text

class Guild {
	
	# Define web colors for guild standings
	public static $standing_color = array( 0 => '#EEE', 1 => '#EC7600', 2 => '#E5C541', 3 => '#EEE', 4 => 'YellowGreen', 5 => 'Lime' );
	
	# Get claim tier by diameter
	public static function get_claim_tier( $diameter ) {
		if( $diameter <= 30  ) return 1;
		if( $diameter <= 50  ) return 2;
		if( $diameter <= 100 ) return 3;
		return 4;
	}
	
	# Translate GuildManager response code
	public static function translate_guildman_code( $code ) {
		global $text;
		switch( $code ) {
			case -1: return $text['gum01']; break;
			case  0: return $text['gum02']; break;
			case  1: return $text['gum03']; break;
		}
	}
	
	# Convert NULL permissions from database to 0/1 string
	protected static function convert_null_permissions( $subjects ) {
		foreach( $subjects AS &$s ) {
			$s['CanEnter']   = (bool)$s['CanEnter'] ? '1' : '0';
			$s['CanBuild']   = (bool)$s['CanBuild'] ? '1' : '0';
			$s['CanClaim']   = (bool)$s['CanClaim'] ? '1' : '0';
			$s['CanUse']     = (bool)$s['CanUse'] ? '1' : '0';
			$s['CanDestroy'] = (bool)$s['CanDestroy'] ? '1' : '0';
		}
		return $subjects;
	}

	# ================================================================================================================== #
	
	private $db;
	public $id, $name, $tag, $charter, $type, $diameter, $center_x, $center_y, $center_geoid, $leader_steam_id, $leader_char_id, $claim_id, $land_id, $founded;
	
	private $producer_char_id;

	public function __construct( $guild_id ) {
		$this->id = intval($guild_id);
		$this->db = new MySQL( $_SESSION['config']['db_user'], $_SESSION['config']['db_pass'], $_SESSION['config']['db_name'], $_SESSION['config']['db_ip'], intval($_SESSION['config']['db_port']) );
	}
	
	# ================================================================================================================== #
	
	# Load details from database
	public function load() {
		
		$rs = $this->db->query( "SELECT g.Name, g.GuildTag, g.GuildCharter, g.GuildTypeID, g.CreateTimestamp, c.ID AS LeaderCharID, a.SteamID AS LeaderSteamID, gl.ID AS LandID, claims.ID AS ClaimID, gl.Radius, gl.CenterGeoID
									FROM `guilds` g
									JOIN `character` c ON g.ID = c.GuildID AND c.GuildRoleID = 1
									JOIN `account` a ON c.AccountID = a.ID
									LEFT JOIN `guild_lands` gl ON g.ID = gl.GuildID AND gl.LandType < 4
									LEFT JOIN `claims` on gl.ID = claims.GuildLandID
									WHERE g.ID = '$this->id'
									ORDER BY g.Name LIMIT 1", FALSE );
		if( empty($rs) ) return FALSE;
		
		$this->name = $rs['Name'];
		$this->tag  = $rs['GuildTag'];
		$this->type = intval($rs['GuildTypeID']);
		$this->leader_steam_id = $rs['LeaderSteamID'];
		$this->leader_char_id = intval($rs['LeaderCharID']);
		$this->claim_id = intval($rs['ClaimID']);
		$this->land_id = intval($rs['LandID']);
		$this->diameter = intval($rs['Radius']);
		$this->center_geoid = intval($rs['CenterGeoID']);
		$this->founded = $rs['CreateTimestamp'];
		$this->details = json_decode($rs['GuildCharter'], TRUE);
		
		return TRUE;
		
	}

	# Get guild standings
	public function get_standings() {
		
		return $this->db->query( "SELECT g.ID, g.Name, g.GuildTypeID, gl.Radius, gs1.StandingTypeID AS OurStanding, gs2.StandingTypeID AS TheirStanding, gl.CenterGeoID, c.Name AS LeaderFirstName, c.LastName AS LeaderLastName, ASCII( SUBSTRING(c.appearance,1) ) AS LeaderGender
									FROM `guilds` g
									JOIN `character` c ON c.GuildID = g.ID AND c.GuildRoleID = 1
									JOIN `guild_lands` gl ON g.ID = gl.GuildID AND gl.LandType < 4
									LEFT JOIN `guild_standings` gs1 ON g.ID = gs1.GuildID2 AND gs1.GuildID1 = $this->id
									LEFT JOIN `guild_standings` gs2 ON g.ID = gs2.GuildID1 AND gs2.GuildID2 = $this->id
									WHERE g.ID <> $this->id
									ORDER BY g.Name ASC" );
									
	}
	
	# Get all members
	public function get_members() {
		
		return $this->db->query( "SELECT c.ID, c.Name, c.LastName, c.GuildRoleID, ASCII( SUBSTRING(c.appearance,1) ) AS Gender, a.SteamID
									FROM `character` c, `account` a 
									WHERE c.AccountID = a.ID AND c.GuildID = '$this->id'
									ORDER BY c.GuildRoleID, c.Name" );
		
	}
	
	# Get rank permissions
	public function get_rank_permissions() {
		
		$r = $this->db->query( "SELECT gr.ID AS GuildRoleID, cr.CanEnter, cr.CanBuild, cr.CanClaim, cr.CanUse, cr.CanDestroy
									FROM guild_roles gr
									LEFT JOIN claim_subjects cs
										INNER JOIN claim_rules cr
										ON cr.ClaimSubjectID = cs.ID AND cr.ClaimID = '$this->claim_id'
									ON cs.GuildRoleID = gr.ID
									ORDER BY gr.ID" );
		return self::convert_null_permissions($r);
		
	}
	
	# Get standing permissions
	public function get_standing_permissions() {
					
		$r = $this->db->query( "SELECT gst.ID AS StandingTypeID, cr.CanEnter, cr.CanBuild, cr.CanClaim, cr.CanUse, cr.CanDestroy
									FROM guild_standing_types gst
									LEFT JOIN claim_subjects cs
										INNER JOIN claim_rules cr
										ON cr.ClaimSubjectID = cs.ID AND cr.ClaimID = '$this->claim_id'
									ON cs.StandingTypeID = gst.ID
									ORDER BY gst.ID" );
		return self::convert_null_permissions($r);
		
	}
	
	# Get foreign guilds individual permissions
	public function get_guild_permissions() {
					
		$r = $this->db->query( "SELECT cs.GuildID, g.Name, cr.CanEnter, cr.CanBuild, cr.CanClaim, cr.CanUse, cr.CanDestroy
									FROM guilds g, claim_rules cr, claim_subjects cs
									WHERE cr.ClaimID = '$this->claim_id' AND cr.ClaimSubjectID = cs.ID AND cs.GuildID = g.ID" );
		return self::convert_null_permissions($r);
		
	}
	
	# Get foreign characters individual permissions
	public function get_char_permissions() {
					
		$r = $this->db->query( "SELECT cs.CharID, c.Name, c.LastName, cr.CanEnter, cr.CanBuild, cr.CanClaim, cr.CanUse, cr.CanDestroy
									FROM `character` c, `claim_rules` cr, `claim_subjects` cs
									WHERE cr.ClaimID = '$this->claim_id' AND cr.ClaimSubjectID = cs.ID AND cs.CharID = c.ID" );
		return self::convert_null_permissions($r);
		
	}
	
	# Check administrative privileges by SteamID and optionally set producer_char_id
	public function is_admin( $steam_id, $setproducer = FALSE ) {
		$rs = $this->db->query( "SELECT c.ID, c.GuildRoleID FROM `character` c, `account` a WHERE c.AccountID = a.ID AND c.GuildID = '$this->id' AND a.SteamID = '$steam_id' ORDER BY GuildRoleID ASC LIMIT 1", FALSE );
		if( ! $rs || intval($rs['GuildRoleID']) > 2 ) return FALSE;
		if( $setproducer ) $this->producer_char_id = intval($rs['ID']);
		return TRUE;
	}
	
	# Check for membership by steamID
	public function is_member( $steam_id ) {
		$rs = $this->db->query( "SELECT c.ID FROM `character` c, `account` a WHERE c.AccountID = a.ID AND c.GuildID = '$this->id' AND a.SteamID = '$steam_id' LIMIT 1", FALSE );
		if( ! $rs ) return FALSE;
		return TRUE;
	}
	
	# ================================================================================================================== #
	
	public function get_detail( $key ) {
	
		if( $this->details === NULL ) return FALSE;
		if( ! isSet($this->details[$key]) ) return FALSE;
		return $this->details[$key];

	}
	
	public function update_charter( $charter, $public ) {
		
		$this->update_charter_object( "GuildCharterPublic", $public );
		$this->update_charter_object( "GuildCharter", $charter );
		return TRUE;
		
	}
	
	private function update_charter_object( $key, $value ) {
		
		$rs = $this->db->query( "SELECT GuildCharter FROM guilds WHERE ID = '$this->id'", FALSE );
		$data = json_decode($rs['GuildCharter'], TRUE);
		if( $data === NULL ) $data = array();
		$data[$key] = $value;
		$json = $this->db->esc(json_encode($data));
		$this->db->query( "UPDATE guilds SET GuildCharter = '$json' WHERE ID = '$this->id'" );
		return TRUE;
		
	}
	
	# ================================================================================================================== #
	
	public function kick_member( $char_id ) {
		$rs = $this->db->query( "SELECT fb_kickFromGuild('$this->producer_char_id', '$char_id', '$this->id') AS TicketID", FALSE );
		return $this->process_ticket($rs['TicketID']);
	}
	
	public function change_standing( $guild_id, $standing_id ) {
		$rs = $this->db->query( "SELECT fb_setGuildStanding('$this->producer_char_id', '$this->id', '$guild_id', '$standing_id') AS TicketID", FALSE );
		return $this->process_ticket($rs['TicketID']);
	}
	
	public function change_rank( $char_id, $rank_id ) {
		$rs = $this->db->query( "SELECT fb_setCharGuildRole('$this->producer_char_id', '$char_id', '$this->id', '$rank_id') AS TicketID", FALSE );
		return $this->process_ticket($rs['TicketID']);
	}
	
	public function change_permission( $type, $id, $enter, $build, $claim, $use, $destroy ) {
		switch($type) {
			case 'standing':	$function = 'fb_setClaimRuleGuildStanding'; break;
			case 'rank':		$function = 'fb_setClaimRuleGuildRole'; 	break;
			case 'guild':		$function = 'fb_setClaimRuleGuild'; 		break;
			case 'char':		$function = 'fb_setClaimRuleChar';			break;
			default: return false;
		}
		$rs = $this->db->query( "SELECT $function('$this->producer_char_id', '$this->claim_id', '$id', $enter, $build, $claim, $use, $destroy) AS TicketID", FALSE );
		return $this->process_ticket($rs['TicketID']);
	}
	
	public function delete_permission( $type, $id ) {
		switch($type) {
			case 'guild':	$function = 'fb_removeClaimRuleGuild'; 	break;
			case 'char':	$function = 'fb_removeClaimRuleChar';	break;
			default: return false;
		}
		$rs = $this->db->query( "SELECT $function('$this->producer_char_id', '$this->claim_id', '$id') AS TicketID", FALSE );
		return $this->process_ticket($rs['TicketID']);
	}
	
	# Process guild action though ticket system
	private function process_ticket( $ticket_id ) {
		
		// Immediately reject invalid tickets
		if( $ticket_id === "0" ) return 0;
		
		$retrx_max = 5;
		$retry_count = 0; 
		
		// Check for result a few times
		do {
			sleep(1);
			$rs = $this->db->query( "SELECT ProcessedStatus FROM guild_actions_processed WHERE TicketID = '$ticket_id'", FALSE );
		} while( empty($rs) && ++$retry_count <= $retrx_max );
		
		// Failed to respond. Server offline.
		if( empty($rs) ) {
			$this->db->query( "DELETE FROM guild_actions_queue WHERE TicketID = '$ticket_id'" );
			return -1;
		} 
		
		// Failed ticket
		if( $rs['ProcessedStatus'] === 'failed' ) return 0;
		
		// Success
		return 1;
		
	}
	

}

?>