<?php

	if( ! isSet($server) ) die;

	session_write_close();

	switch($_REQUEST['ajax']) {
		
		# Online players and max players
		case 'online_count':
		
			echo json_encode( array($server->get_server_info('Players'), $server->get_server_info('MaxPlayers')) );
			
		break;
		
		# Online player list and positions
		case 'online_players':
		
			if( $mygroup->privileges['online_list'] ) {

				echo json_encode( $server->get_online_players($mygroup->privileges['player_layer']) );
				
			}
			
		break;
		
		# Get Judgement-Hour info
		case 'jh_info':
		
			echo json_encode( $server->get_judgement_hour() );
			
		break;
		
		# Get paved roads
		case 'get_paved':

			if( $mygroup->privileges['road_layer'] ) {
				
				@set_time_limit(600);
				
				// Get cached and current version sum
				$rs = Livemap::$db->query( "SELECT geo_cache_version FROM {$config['table_c']} WHERE ID = '$livemap_id'", FALSE );
				$cached_version = intval($rs['geo_cache_version']);
				$current_version = $server->get_geo_version_sum();

				// Need full refresh after FT map-refresh script
				$force_refresh = ( $cached_version > $current_version );
				
				// Use cache if it's not terribily outdated
				$use_cache = ( $current_version < ($cached_version + 3000) && ! $force_refresh );

				// Output json data
				ob_start();
				echo json_encode( $server->get_paved_tiles($use_cache) );
				
				// Close connection to browser
				ignore_user_abort(TRUE);
				header( 'Connection: close' );
				header( 'Content-Length: '.ob_get_length() );
				ob_end_flush();
				ob_flush();
				flush();
				
				// Update cache if version changed
				if( $current_version > $cached_version + 500 || $force_refresh ) {
					Livemap::$db->query( "UPDATE {$config['table_c']} SET geo_cache_version = '$current_version' WHERE ID = '$livemap_id'" );
					$server->cache_paved_tiles();
				}

			} else {
				
				echo "[]";
				
			}
			
		break;
		
		# Get buildings / structures
		case 'get_structures':
		
			if( $mygroup->privileges['struct_layer'] ) {

				echo json_encode( $server->get_structures() );
				
			} else {
				
				echo "[]";
				
			}

		break;
		
		# Get regions
		case 'get_regions':
		
			echo json_encode( $server->passthru_db_query("SELECT ID, RegionID FROM terrain_blocks") );

		break;
		
		# Get player inventory and equipment
		case 'player_inventory':
		
			if( $mygroup->privileges['manage_chars'] && isSet($_POST['char_id']) ) {
				
				$id = intval($_POST['char_id']);
				
				echo json_encode( $server->get_character_inventory($id) );
				
			} else {
				
				echo "{}";
				
			}
		
		break;
		
		# Get player inventory and equipment
		case 'player_statistics':
		
			if( $mygroup->privileges['manage_chars'] && isSet($_POST['char_id']) ) {
				
				$id = intval($_POST['char_id']);
	
				echo json_encode( $server->get_character_stats($id) );
				
			} else {
				
				echo "{}";
				
			}
		
		break;
		
		# Get player skills
		case 'player_skills':
		
			if( $mygroup->privileges['manage_chars'] && isSet($_POST['char_id']) ) {
				
				$id = intval($_POST['char_id']);
	
				echo json_encode( $server->get_character_skills($id) );
				
			} else {
				
				echo "{}";
				
			}
		
		break;
		
		# Update player skills
		case 'skill_update':
		
			if( $mygroup->privileges['manage_adv'] && isSet($_POST['char_id'], $_POST['skill_id'], $_POST['skill_value']) ) {
				
				$char_id = intval($_POST['char_id']);
				$skill_id = intval($_POST['skill_id']);
				$skill_value = floatval($_POST['skill_value']);
				if( $skill_value < 0 || $skill_value > 100 ) die('ERROR');
					
				if( ! $server->set_character_skill($char_id, $skill_id, $skill_value) ) die('ERROR');
				
				echo 'OK';
				
			} else {
				
				echo "ERROR";
				
			}
		
		break;
		
		# Check my privileges
		case 'priv_check':
		
			if( ! (bool)intval($config['guildmanager']) || ! isSet($_SESSION['SteamAuth']) ) die('ERROR');
			
			$guild_id = intval($_GET['guild']);
			$char_id  = intval($_GET['char']);
			
			// Get characters guild
			$tmp = $server->passthru_db_query("SELECT GuildID FROM `character` c, `account` a WHERE c.AccountID = a.ID AND a.SteamID = '{$_SESSION['SteamAuth']['steam_id']}' AND c.ID = '$char_id'", FALSE);
			if( ! $tmp ) die('ERROR');
			$char_guild_id = intval($tmp['GuildID']);
			
			// Is member?
			$is_member = ($char_guild_id === $guild_id);

			// Get Standing
			$standing = $server->get_guild_standings($guild_id, $char_guild_id);
			$standing_id = empty($standing) ? 1 : intval($standing[0]['StandingTypeID']);

			$result = array(
				'permissions' => $server->get_char_permissions($char_id, $guild_id),
				'standing' => $standing_id,
				'is_member' => $is_member
			);
			
			if( ! $result ) die('ERROR');
			echo json_encode($result);
			
		break;
		
	}

	die;
	
?>