<?php

	// Check steam login and 
	$redirect = "index.php?livemap_id=$livemap_id&s=guildman";
	if( ! isSet($_REQUEST['command'], $_SESSION['SteamAuth']) || ! $_SESSION['SteamAuth']['steam_id'] ) error_redirect($redirect);
	
	// Check source guild id
	if( ! isSet($_REQUEST['source_guild_id']) ) error_redirect($redirect);
	if( ! $source_id = intval($_REQUEST['source_guild_id']) ) error_redirect($redirect);
	
	// Init source guild
	$guild = new Guild($source_id);
	$guild->load();
	
	// Check permission and set producer char id
	if( ! $guild->is_admin($_SESSION['SteamAuth']['steam_id'], TRUE) ) error_redirect($redirect, "You don't have permission to run this command");

	switch( $_REQUEST['command'] ) {
		
		case 'kick_member':
		
			$redirect = "index.php?livemap_id=$livemap_id&s=guildman&m=members&gid=$source_id";
		
			// Check required input vars 
			if( ! isSet($_GET['subject_id']) ) error_redirect($redirect);
			
			$subject_id = intval($_GET['subject_id']);
			if( ! $subject_id ) error_redirect($redirect);
			
			// Process action in database
			$code = $guild->kick_member($subject_id);
			if( $code === 1 ) success_redirect($redirect, Guild::translate_guildman_code($code));
			else error_redirect($redirect, Guild::translate_guildman_code($code));
			
		break;
		
		case 'update_charter':
		
			$redirect = "index.php?livemap_id=$livemap_id&s=guildman";
		
			// Check required input vars 
			if( ! isSet($_POST['charter'], $_POST['public']) ) error_redirect($redirect);

			// Process action in database
			if( $guild->update_charter($_POST['charter'], (bool)$_POST['public']) ) success_redirect($redirect, Guild::translate_guildman_code(1));
			else error_redirect($redirect, Guild::translate_guildman_code(0));
			
		break;
		
		case 'change_rank':
		
			$redirect = "index.php?livemap_id=$livemap_id&s=guildman&m=members&gid=$source_id";
		
			// Check required input vars 
			if( ! isSet($_POST['subject_id'], $_POST['rank']) ) error_redirect($redirect);
			
			$subject_id = intval($_POST['subject_id']);
			$rank_id = intval($_POST['rank']);
			if( ! $subject_id || ! $rank_id ) error_redirect($redirect);
			
			// Process action in database
			$code = $guild->change_rank($subject_id, $rank_id);
			if( $code === 1 ) success_redirect($redirect, Guild::translate_guildman_code($code));
			else error_redirect($redirect, Guild::translate_guildman_code($code));
			
		break;

		case 'change_standing':
		
			$redirect = "index.php?livemap_id=$livemap_id&s=guildman&m=standings&gid=$source_id";
		
			// Check required input vars 
			if( ! isSet($_POST['target_guild_id'], $_POST['standing']) ) error_redirect($redirect);
			
			$target_id = intval($_POST['target_guild_id']);
			$standing  = intval($_POST['standing']);
			if( ! $target_id || ! $standing ) error_redirect($redirect);
			
			// Process action in database
			$code = $guild->change_standing($target_id, $standing);
			if( $code === 1 ) success_redirect($redirect, Guild::translate_guildman_code($code));
			else error_redirect($redirect, Guild::translate_guildman_code($code));
		
		break;
		
		case 'change_permission':
		
			$redirect = "index.php?livemap_id=$livemap_id&s=guildman&m=permissions&gid=$source_id";
		
			// Check required input vars 
			if( ! isSet($_POST['subject_type'], $_POST['subject_id']) ) error_redirect($redirect);
			if( ! in_array($_POST['subject_type'], ['standing','rank','guild','char']) ) error_redirect($redirect);
			
			$redirect .= "#{$_POST['subject_type']}";
			
			$subject_id = intval($_POST['subject_id']);
			$enter = intval(isSet($_POST['CanEnter']));
			$build = intval(isSet($_POST['CanBuild']));
			$claim = intval(isSet($_POST['CanClaim']));
			$use = intval(isSet($_POST['CanUse']));
			$destroy = intval(isSet($_POST['CanDestroy']));

			// Process action in database
			$code = $guild->change_permission($_POST['subject_type'], $subject_id, $enter, $build, $claim, $use, $destroy);
			if( $code === 1 ) success_redirect($redirect, Guild::translate_guildman_code($code));
			else error_redirect($redirect, Guild::translate_guildman_code($code));
		
		break;
		
		case 'delete_permission':
		
			$redirect = "index.php?livemap_id=$livemap_id&s=guildman&m=permissions&gid=$source_id";
		
			if( isSet($_GET['char_id']) ) {
				$type = 'char';
				$subject_id = intval($_GET['char_id']);
			}
			elseif( isSet($_GET['guild_id']) ) {
				$type = 'guild';
				$subject_id = intval($_GET['guild_id']);
			} else {
				error_redirect($redirect);
			}

			$redirect = "index.php?livemap_id=$livemap_id&s=guildman&m=permissions&gid=$source_id#$type";
			
			// Process action in database
			$code = $guild->delete_permission($type, $subject_id);
			if( $code === 1 ) success_redirect($redirect, Guild::translate_guildman_code($code));
			else error_redirect($redirect, Guild::translate_guildman_code($code));

		break;
				
	}
	
?>