<?php

	$redirect   = "index.php?livemap_id=$livemap_id&s=rcon";
	$message_ok = "Command was sent to server and will be executed within the next 20 seconds.";

	if( ! isSet($_POST['command']) ) error_redirect($redirect);

	switch( $_POST['command'] ) {
		
		# Message all players 
		case 'message_all':

			if( ! $mygroup->privileges['rcon'] ) error_redirect($redirect);
		
			if( ! isSet($_POST['message'], $_POST['function']) ) error_redirect($redirect);
		
			$message  = trim( $cdb->esc($_POST['message']) );
			$function = $_POST['function'];
			$duration = isSet($_POST['seconds']) ? intval($_POST['seconds']) : 10;
			
			// Check message
			if( strlen($message) < 1 ) error_redirect($redirect, "Message can't be empty");
			// Check function
			if( ! in_array($function, array('centerprintall','bottomprintall','system_msg_all','local_msg_all')) ) error_redirect($redirect);
			// Check duration
			if( $duration < 5 || $duration > 120  ) error_redirect($redirect);
			
			$server->add_rcon_command( $function, $duration, '', $message );
			Livemap::log_action( 'rcon_message_all', "($function) $message" );

			success_redirect($redirect, $message_ok);
			
		break; # ----------------------------------------------------------------------------------------------------------------
		
		# Teleport all players 
		case 'teleport_all':

			if( ! $mygroup->privileges['rcon'] ) error_redirect($redirect);
		
			if( ! isSet($_POST['dst_type']) ) error_redirect($redirect);
		
			// to other player
			if( $_POST['dst_type'] === 'player' ) {
				if( ! isSet($_POST['subject_id']) || intval($_POST['subject_id']) < 1 ) error_redirect($redirect);
				$subject = intval($_POST['subject_id']);
				$subject_type = 'player';
				$logdetail = "To CharID $subject";
			// to certain GeoID
			} else {
				if( ! isSet($_POST['geo_id']) || intval($_POST['geo_id']) < 1000000 ) error_redirect($redirect);
				$subject = intval($_POST['geo_id']);
				$subject_type = 'location';
				$logdetail = "To GeoID $subject";
			}

			$server->add_rcon_command( 'teleport', 'ALL', $subject, $subject_type );
			Livemap::log_action( 'rcon_teleport_all', $logdetail );

			success_redirect($redirect, $message_ok);
			
		break; # ----------------------------------------------------------------------------------------------------------------
		
		# Insert Item to Everyone
		case 'insert_item_all':
		
			if( ! $mygroup->privileges['rcon'] ) error_redirect($redirect);
		
			// Check input
			if( ! isSet($_POST['item_id'], $_POST['item_name_id'], $_POST['item_data_type'], $_POST['quantity'], $_POST['quality'], $_POST['durability']) ) error_redirect($redirect);
		
			$quantity = intval($_POST['quantity']);
			$quality = intval($_POST['quality']);
			$durability = intval($_POST['durability']);
			$object_id = $_POST['item_data_type'] === 'id' ? intval($_POST['item_id']) : intval($_POST['item_name_id']);
			
			// Checks
			if( $quantity < 1 || $quantity > 1000 ) error_redirect($redirect, "Invalid Quantity");
			if( $quality < 1 || $quality > 1000 ) error_redirect($redirect, "Invalid Quality");
			if( $object_id < 1 || $object_id > 9999 ) error_redirect($redirect, "Invalid Item ID");
			if( $durability < 1 || $durability > 20000 ) error_redirect($redirect, "Invalid Durability");

			$server->add_rcon_command( 'insert_item_all', '', $object_id, "$quantity|$quality|$durability" );
			Livemap::log_action( 'rcon_insert_item', "All players / ObjectID $object_id / Quantity $quantity / Quality $quality" );
			
			success_redirect($redirect, $message_ok);
			
		break; # ----------------------------------------------------------------------------------------------------------------
		
		# Trigger a function
		case 'exec_function':
		
			if( ! $mygroup->privileges['rcon_advanced'] ) error_redirect($redirect);
		
			$valid_functions = array( 'forest_grow', 'crops_grow', 'patch_maint', 'spawn_maint' );
		
			// Check input
			if( ! isSet($_POST['function']) ) error_redirect($redirect);
			if( ! in_array( $_POST['function'], $valid_functions ) ) error_redirect($redirect, 'Invalid function called.');
			
			$function = $cdb->esc($_POST['function']);

			$server->add_rcon_command( $function );
			Livemap::log_action( 'rcon_exec_function', $function );

			success_redirect($redirect, $message_ok);
			
		break; # ----------------------------------------------------------------------------------------------------------------
		
		# Run a custom command
		case 'exec_command':
		
			if( ! $mygroup->privileges['rcon_advanced'] ) error_redirect($redirect);
		
			// Check input
			if( ! isSet($_POST['command_string']) ) error_redirect($redirect);
			
			$command = $cdb->esc( trim($_POST['command_string']) );
			
			if( strlen($command) < 1 ) error_redirect($redirect, "Command can't be empty");
			
			$server->add_rcon_command( 'exec_command', '', '', $command );
			Livemap::log_action( 'rcon_exec_command', $command );
		
			success_redirect($redirect, $message_ok);
			
		break; # ----------------------------------------------------------------------------------------------------------------
		
		# Teleport player
		case 'teleport_player':

			if( ! $mygroup->privileges['rcon'] ) error_redirect($redirect);
		
			if( ! isSet($_POST['dst_type'], $_POST['char_id']) ) error_redirect($redirect);
		
			$char_id = intval($_POST['char_id']);
			if( $char_id < 1 ) error_redirect($redirect);
			
			// to other player
			if( $_POST['dst_type'] === 'player' ) {
				if( ! isSet($_POST['subject_id']) || intval($_POST['subject_id']) < 1 ) error_redirect($redirect);
				$subject = intval($_POST['subject_id']);
				$subject_type = 'player';
				$logdetail = "CharID $char_id to CharID $subject";
			// to certain GeoID
			} else {
				if( ! isSet($_POST['geo_id']) || intval($_POST['geo_id']) < 1000000 ) error_redirect($redirect);
				$subject = intval($_POST['geo_id']);
				$subject_type = 'location';
				$logdetail = "CharID $char_id to GeoID $subject";
			}
			
			if( $subject === $char_id ) error_redirect($redirect, "You can\'t teleport a player to oneself.");

			$server->add_rcon_command( 'teleport', $char_id, $subject, $subject_type );
			Livemap::log_action( 'rcon_teleport', $logdetail );

			success_redirect($redirect, $message_ok);
		
		# Kick player
		case 'kick_player':
		
			if( ! $mygroup->privileges['rcon'] ) error_redirect($redirect);
		
			// Check input
			if( ! isSet($_POST['char_id'], $_POST['message']) ) error_redirect($redirect);
		
			$char_id = intval($_POST['char_id']);
			$message = $cdb->esc($_POST['message']);
			if( strlen($message) < 1 ) $message = "You were kicked from the server via RCON";
			
			$server->add_rcon_command( 'kick_player', $char_id, '', $message );
			Livemap::log_action( 'rcon_kick_player', "CharID $char_id / Message: $message" );
		
			success_redirect($redirect, $message_ok);
			
		break; # ----------------------------------------------------------------------------------------------------------------
		
		# Ban player
		case 'ban_player':
		
			if( ! $mygroup->privileges['rcon'] ) error_redirect($redirect);
		
			// Check input
			if( ! isSet($_POST['char_id'], $_POST['bantype']) ) error_redirect($redirect);
		
			$char_id = intval($_POST['char_id']);
			$permaban = ( $_POST['bantype'] === 'permanent' );
			
			if( $permaban ) {
				$message = "You've been permanently banned from this server.";
				$duration = 0;
			} else {
				$duration   = intval($_POST['duration']);
				$duration_h = floor($duration/60);
				$duration_m = $duration % 60;
				$message = "You are banned from this server for $duration_h hours and $duration_m minutes.";
			}

			// Ban the account of this character
			$server->ban_player( $char_id );
			// Kick player from the server
			$server->add_rcon_command( 'kick_player', $char_id, '', $message );
			// Schedule unban if duration was set
			if( ! $permaban ) {
				$server->add_rcon_command( 'unban_player', $char_id, '', '', $duration );
				Livemap::log_action( 'rcon_ban_player', "CharID $char_id / Duration: $duration s" );
			} else {
				Livemap::log_action( 'rcon_ban_player', "CharID $char_id / Duration: Permanent" );
			}
			
			success_redirect($redirect, $message_ok);
			
		break; # ----------------------------------------------------------------------------------------------------------------
		
		# Message player
		case 'message_player':
		
			if( ! $mygroup->privileges['rcon'] ) error_redirect($redirect);
		
			// Check input
			if( ! isSet($_POST['char_id'], $_POST['function'], $_POST['message']) ) error_redirect($redirect);
		
			$char_id  = intval($_POST['char_id']);
			$duration = isSet($_POST['seconds']) ? intval($_POST['seconds']) : 10;
			$function = $_POST['function'];
			$message  = $cdb->esc($_POST['message']);
			
			// Check message
			if( strlen($message) < 1 ) error_redirect($redirect, "Message can't be empty");
			// Check function
			if( ! in_array($function, array('centerprint','bottomprint','system_msg','local_msg')) ) error_redirect($redirect);
			// Check duration
			if( $duration < 5 || $duration > 120 ) error_redirect($redirect);
			
			$server->add_rcon_command( $function, $char_id, $duration, $message );
			Livemap::log_action( 'rcon_message_player', "CharID $char_id / Message: $message" );
			
			success_redirect($redirect, $message_ok);
			
		break; # ----------------------------------------------------------------------------------------------------------------
		
		# Message player
		case 'insert_item':
		
			if( ! $mygroup->privileges['rcon'] ) error_redirect($redirect);
		
			// Check input
			if( ! isSet($_POST['char_id'], $_POST['item_id'], $_POST['item_name_id'], $_POST['item_data_type'], $_POST['quantity'], $_POST['quality'], $_POST['durability']) ) error_redirect($redirect);
		
			$char_id = intval($_POST['char_id']);
			$quantity = intval($_POST['quantity']);
			$quality = intval($_POST['quality']);
			$durability = intval($_POST['durability']);
			$object_id = $_POST['item_data_type'] === 'id' ? intval($_POST['item_id']) : intval($_POST['item_name_id']);
			
			// Checks
			if( $quantity < 1 || $quantity > 1000 ) error_redirect($redirect, "Invalid Quantity");
			if( $quality < 1 || $quality > 1000 ) error_redirect($redirect, "Invalid Quality");
			if( $object_id < 1 || $object_id > 9999 ) error_redirect($redirect, "Invalid Item ID");
			if( $durability < 1 || $durability > 20000 ) error_redirect($redirect, "Invalid Durability");

			$server->add_rcon_command( 'insert_item', $char_id, $object_id, "$quantity|$quality|$durability" );
			Livemap::log_action( 'rcon_insert_item', "CharID $char_id / ObjectID $object_id / Quantity $quantity / Quality $quality" );
			
			success_redirect($redirect, $message_ok);
			
		break; # ----------------------------------------------------------------------------------------------------------------
		
		default:
		
			error_redirect($redirect, 'Unknown RCON command');
			
		
	}

?>