<?php

# Livemap Class 
# Page config and global functions to be migrated here ... soon™

class Livemap {
	
	protected function __construct() {}
	protected function __clone() {}
	
	public static $db, $config, $mygroup;
	
	public static function configure( $config, MySQL $db, Group $mygroup ) {
		self::$db = $db;
		self::$config = $config;
		self::$mygroup = $mygroup;
		self::$language = $config['language'];
	}

	
	# ======================================================================================================================================================================================= #
	# Font business
	
	public static $fonts = array(
		[ 'name' => 'Alice', 'import' => 'https://fonts.googleapis.com/css?family=Alice' ],
		[ 'name' => 'Calibri', 'import' => FALSE ],
		[ 'name' => 'Gentium Book Baisc', 'import' => 'https://fonts.googleapis.com/css?family=Gentium+Book+Basic' ],
		[ 'name' => 'Georgia', 'import' => FALSE ],
		[ 'name' => 'IM Fell English SC', 'import' => 'https://fonts.googleapis.com/css?family=IM+Fell+English+SC' ],
		[ 'name' => 'Kurale', 'import' => 'https://fonts.googleapis.com/css?family=Kurale' ],
		[ 'name' => 'Libre Baskerville', 'import' => 'https://fonts.googleapis.com/css?family=Libre+Baskerville' ],
		[ 'name' => 'Lore', 'import' => 'https://fonts.googleapis.com/css?family=Lora' ],
		[ 'name' => 'Marko One', 'import' => 'https://fonts.googleapis.com/css?family=Marko+One' ],
		[ 'name' => 'Mate SC', 'import' => 'https://fonts.googleapis.com/css?family=Mate+SC' ],
		[ 'name' => 'Oleo Script', 'import' => 'https://fonts.googleapis.com/css?family=Oleo+Script' ],
		[ 'name' => 'Palatino Linotype', 'import' => FALSE ],
		[ 'name' => 'Source Sans Pro', 'import' => 'https://fonts.googleapis.com/css?family=Source+Sans+Pro' ],
		[ 'name' => 'Tahoma', 'import' => FALSE ],
		[ 'name' => 'Trebuchet MS', 'import' => FALSE ],
		[ 'name' => 'Verdana', 'import' => FALSE ],
		[ 'name' => 'Vidaloka', 'import' => 'https://fonts.googleapis.com/css?family=Vidaloka' ],
	);
	
	public static $fonts_imported = array();
	
	public static function get_font_names() { $r = array(); foreach( self::$fonts AS $font ) array_push($r, $font['name']); return $r; }
	
	public static function load_font( $name ) { foreach( self::$fonts AS $font ) if( $font['name'] === $name && $font['import'] !== FALSE && ! in_array($name, self::$fonts_imported) ) array_push( self::$fonts_imported, $font['import'] ); }
	
	
	# ======================================================================================================================================================================================= #
	# Translation business
	
	public static $languages = array(
		'en' => 'English',
		'fr' => 'French',
		'de' => 'German',
		'it' => 'Italian',
		'es' => 'Spanish',
		'ru' => 'Russian'
	);
	
	public static $language = 'en';
	
	
	# ======================================================================================================================================================================================= #
	# Logging 

	public static function log_action( $action, $detail = '') {
		$query  = sprintf("INSERT INTO %s (livemap_id, user_group, action, detail) VALUES ('%u', '%s', '$action', '$detail')", self::$config['table_l'], intval(self::$config['ID']), self::$db->esc(self::$mygroup->name) );
		return ( self::$db->query($query) > 0 );
	}
	
	
	# ======================================================================================================================================================================================= #
	# Helper functions
	
	public static function geoid2pixelpos( $geoid ) {
		
		$TerID = $geoid >> 18;
		$TerX  = $geoid & ((1 << 9) - 1);
		$TerY  = ($geoid >> 9) & ((1 << 9) - 1);
		
		return self::terpos2pixelpos($TerID, $TerX, $TerY);
		
	}

	public static function terpos2pixelpos( $TerID, $TerX, $TerY ) {
	
		switch( $TerID ) {
			case 442:
			case 443:
			case 444:	$y = 1532 - $TerY;		break;
			case 445:
			case 446:
			case 447:	$y = 1021 - $TerY;		break;
			default:	$y =  510 - $TerY;		break;
		}
		switch( $TerID ) {
			case 443:	
			case 446:	
			case 449:	$x = $TerX + 511;		break;
			case 444:	
			case 447:	
			case 450:	$x = $TerX + 1022;		break;
			default:	$x = $TerX;
		}
		
		return array( intval($x), intval($y) );
	
	}
	
	public static function get_distance( $a, $b ) {
		
		if( is_numeric($a) && is_numeric($b) ) {
			$a = self::geoid2pixelpos($a);
			$b = self::geoid2pixelpos($b);
		}

		$x = abs($a[0] - $b[0]);
		$y = abs($a[1] - $b[1]);
		return hypot($x, $y);

	}
	
}

?>