function MasterObject() {
	
	var self = this;
	
	// Data properties
	this.nextRestarts = [];
	this.nextJH = [];
	this.onlinePlayers = null;
	this.dayOfYear = null;
	
	// Reference properties
	this.onlineListTooltip = null;
	this.restartsTooltip   = null;
	this.weatherTooltip    = null;
	
	// Status properties
	this.rconNeedsUpdate = true;
	
	// Fixed ajax loader images
	this.loaderLarge = new Image();
	this.loaderLarge.src = 'img/ajax-loader-large.gif';
	
	// JQ Dialogs
	this.groupAuthDialog = $("#dialog-group-auth").dialog( {autoOpen: false, resizable: false, height: "auto", width: "auto", modal: true, buttons: {"Login": function() {$("#form-group-auth")[0].submit();}, "Close": function() {$(this).dialog("close");}} } );
	this.steamAuthDialog = $("#dialog-steam-auth").dialog( {autoOpen: false, resizable: false, height: "auto", width: "auto", modal: true, buttons: {"Close": function() {$(this).dialog("close");}} } );
	this.creditsDialog = $("#dialog-credits").dialog( {autoOpen: false, resizable: false, height: "auto", width: "auto", modal: true, buttons: {"Close": function() {$(this).dialog("close");}} } );
	
	// Refresh online player count
	this.refreshOnlineCount = function() {
		
		var data = new FormData();
		data.append( 'ajax', 'online_count' );
		
		ajax_send( data, function(response) {
			// Error checks
			if( typeof(response) === 'undefined' ) return false;
			if( response === '' ) return false;
			try {
				var data = JSON.parse(response);
				// Server offline
				if( data[0] === false ) {
					document.getElementById('online_players').innerHTML = 'Server offline!';
					document.getElementById('online_players_text').style.display = 'none';
					self.onlineListTooltip.deactivate();
				// Server online, non-public, servermod installed
				} else if( data[1] === false ) {
					document.getElementById('online_players').innerHTML = data[0];
					document.getElementById('online_players_text').style.display = 'inline';
					self.onlineListTooltip.activate();
				// Server online, public
				} else {
					document.getElementById('online_players').innerHTML = data[0] + ' / ' + data[1];
					document.getElementById('online_players_text').style.display = 'inline';
					self.onlineListTooltip.activate();
				}
			} catch(e) {
				return false;
			}
		} );
		
	};
	
	// Refresh list of online players
	this.getOnlinePlayers = function() {
		
		var data = new FormData();
		data.append( 'ajax', 'online_players' );
		
		ajax_send( data, function(response) {
			// Error checks
			if( typeof(response) === 'undefined' ) return false;
			if( response === '' ) return false;
			// Update players global variable
			self.onlinePlayers = JSON.parse(response);
			// Clear and redraw player markers on livemap
			if( typeof Livemap !== 'undefined' ) {
				if( Livemap.showPlayers ) {
					Livemap.removePlayerMarkers();
					Livemap.drawPlayerMarkers();
				}
			}
			self.updateOnlineList();
		} );
		
	};
	
	// Update list of online players
	this.updateOnlineList = function() {
		
		var htmlstring = "<b>" + Text.nowon + ":</b><ul id='online-list'>";
		for( var i = 0; i < this.onlinePlayers.length; i++ ) {
			htmlstring += "<li>&diams; " + this.onlinePlayers[i].FirstName + " " + this.onlinePlayers[i].LastName;
			for( var j = 0; j < this.onlinePlayers[i].tags.length; j++ ) htmlstring += " <sup style='color: #" + this.onlinePlayers[i].tags[j].tag_color + "' title='" + this.onlinePlayers[i].tags[j].tag_name + "'>" + this.onlinePlayers[i].tags[j].tag + "</sup>";
			htmlstring += "</li>";
		}
		if( this.onlinePlayers.length === 0 ) htmlstring += "<i>" + Text.noone + "</i>";
		htmlstring += "</ul>";

		document.getElementById('header-players').style.cursor = 'help';

		this.onlineListTooltip.setContent(htmlstring);

		// Guild member status icon
		var icons = document.getElementsByClassName('player-status-icon');
		for( var i = 0; i < icons.length;   i++ ) {
			icons[i].src = "img/blank.png";
		}
		for( var i = 0; i < this.onlinePlayers.length; i++ ) {
			var element = document.getElementById('player_status_' + this.onlinePlayers[i].ID);
			if( element !== null ) element.src = "img/player-online-icon.png";
		}
		
		if( this.rconNeedsUpdate ) this.updateRconList();

	};
	
	// Trigger RCON list update
	this.triggerRconUpdate = function() {
		$('#rcon-refresh-button').hide();
		$('#rcon-loader-wide').show();
		this.rconNeedsUpdate = true;
		// Add visible delay
		setTimeout( function() { self.getOnlinePlayers(); }, 500 );
	};
	
	// Update RCON list
	this.updateRconList = function() {
		
		var table = document.getElementById('rcon-player-list');
		if( table !== null ) {
			
			var old_tbody = table.tBodies[0];
			var new_tbody = document.createElement('tbody');
			
			$(".rcon-player-select").empty();
			
			for( var i = 0; i < this.onlinePlayers.length; i++ ) { 
			
				$(".rcon-player-select").append( $("<option value='" + self.onlinePlayers[i].ID + "'>" + self.onlinePlayers[i].FirstName + ' ' + self.onlinePlayers[i].LastName + "</option>") );
			
				(function(i) {
					var gender_icon = new Image();
					gender_icon.src = self.onlinePlayers[i].gender === '1' ? 'img/ni-male.png' : 'img/ni-female.png';
					gender_icon.title = self.onlinePlayers[i].gender === '1' ? 'Male' : 'Female';
					var btn_kick = new Image();
					btn_kick.src = 'img/tt/icon_kick.png';
					btn_kick.className = 'control-icon';
					btn_kick.title = 'Kick Player';
					btn_kick.onclick = function() { 
						document.getElementById('kick-char-id').value = self.onlinePlayers[i].ID;
						document.getElementById('kick-char-name').innerHTML = self.onlinePlayers[i].FirstName + ' ' + self.onlinePlayers[i].LastName;
						self.toggleDialogue('rcon-kick-window');
					};
					var btn_ban = new Image();
					btn_ban.src = 'img/tt/icon_ban.png';
					btn_ban.className = 'control-icon';
					btn_ban.title = 'Ban Player';
					btn_ban.onclick = function() { 
						document.getElementById('ban-char-id').value = self.onlinePlayers[i].ID;
						document.getElementById('ban-char-name').innerHTML = self.onlinePlayers[i].FirstName + ' ' + self.onlinePlayers[i].LastName;
						self.toggleDialogue('rcon-ban-window');
					};
					var btn_msg = new Image();
					btn_msg.src = 'img/tt/icon_msg.png';
					btn_msg.className = 'control-icon';
					btn_msg.title = 'Message Player';
					btn_msg.onclick = function() { 
						document.getElementById('msg-char-id').value = self.onlinePlayers[i].ID;
						document.getElementById('msg-char-name').innerHTML = self.onlinePlayers[i].FirstName + ' ' + self.onlinePlayers[i].LastName;
						self.toggleDialogue('rcon-msg-window');
					}
					var btn_item = new Image();
					btn_item.src = 'img/tt/icon_item.png';
					btn_item.className = 'control-icon';
					btn_item.title = 'Give Item';
					btn_item.onclick = function() { 
						document.getElementById('item-char-id').value = self.onlinePlayers[i].ID;
						document.getElementById('item-char-name').innerHTML = self.onlinePlayers[i].FirstName + ' ' + self.onlinePlayers[i].LastName;
						self.toggleDialogue('rcon-item-window');
					}
					var btn_tele = new Image();
					btn_tele.src = 'img/ni-locate.png';
					btn_tele.className = 'control-icon';
					btn_tele.title = 'Teleport';
					btn_tele.onclick = function() { 
						openTeleportDialog( self.onlinePlayers[i].ID, self.onlinePlayers[i].FirstName + ' ' + self.onlinePlayers[i].LastName );
					}
					var tr = new_tbody.insertRow();
					tr.insertCell().appendChild(gender_icon);
					tr.insertCell().innerHTML = self.onlinePlayers[i].FirstName + " " + self.onlinePlayers[i].LastName;
					var action = tr.insertCell();
					action.appendChild(btn_msg);
					action.appendChild(btn_item);
					action.appendChild(btn_tele);
					action.appendChild(btn_kick);
					action.appendChild(btn_ban);
					
				})(i);
			}
			
			table.replaceChild(new_tbody, old_tbody);
			
			$('#rcon-refresh-button').show();
			$('#rcon-loader-wide').hide();
			
		}
		
		this.rconNeedsUpdate = false;
		
	};
	
	
	// Update the timer for JH or NR
	this.updateTimer = function( subject ) {

		if( subject === 'nr' || subject === 'jh' ) {
	
			var timestamps = subject === 'nr' ? this.nextRestarts : this.nextJH.timestamps;
			
			var next  = Date.now() * 2;
			var ndiff = 0;

			// Detect closest future timestamp
			for( var i = 0; i < timestamps.length; i++ ) {
				var time = parseInt(timestamps[i]) * 1000;
				var diff = time - Date.now();
				if( diff >= 0 && time < next ) {
					ndiff = diff;
					next  = time;
				}
			}
			
			// Calculate days/hours/min/sec left
			var day = Math.floor( ndiff / 1000 / 60 / 60 / 24 );
			var hrs = '0' + Math.floor( ndiff / 1000 / 60 / 60 % 24 );
			var min = '0' + Math.floor( ndiff / 1000 / 60 % 60 );
			var sec = '0' + Math.floor( ndiff / 1000 % 60  );
			
		}
		
		switch( subject ) {
			
			// In-game date and time
			case 'gt':
			
				// Get current game time
				var date = this.getGameTime(Config.dayCycle);
				
				// Update time
				var timestring = date.getUTCHours().pad(2) + ':' + date.getUTCMinutes().pad(2) + ' &nbsp;<span class="smallgray">' + date.getUTCDate().pad(2) + '/' + (date.getUTCMonth()+1).pad(2) + '/' + (date.getUTCFullYear()-1000) + '</span>';
				var span = document.getElementById('gametime');
				span.innerHTML = timestring;
				
				// Get game of year
				var start = Date.UTC(date.getUTCFullYear(), 0, 1);
				var dayOfYear = Math.floor( (date.getTime() - start ) / 86400000 );

				// On day change, update weather and forecast 
				if( this.dayOfYear !== dayOfYear ) {
					// Update day of year
					this.dayOfYear = dayOfYear;
					// Find correct record in weatherInfo array
					for( var i = 0; i < Config.weatherInfo.length; i++ ) {
						var weather = Config.weatherInfo[i];
						if( weather.day === this.dayOfYear ) {
							// Update visuals
							var icon = document.getElementById('weather-icon');
							icon.src = 'img/ni-weather-' + weather.weather + '.png';
							var span_now = document.getElementById('weather-now');
							span_now.innerHTML = Text[weather.weather];
							var span_tomorrow = document.getElementById('weather-tomorrow');
							span_tomorrow.innerHTML = typeof Config.weatherInfo[i+1] == 'object' ? Text[Config.weatherInfo[i+1].weather] : '?';
							break;
						}
					}
					// Spawn weather forecast if data available
					if( Config.weatherInfo.length > 7 ) this.generateWeatherForecast();
				}
				
			
			break;
		
			// Next restart timer
			case 'nr':
			
				// Get timer span element and warn icon element
				var span = document.getElementById('nr_timer');
				var warn = document.getElementById('warn-icon');
				
				// Update timer in DOM
				span.innerHTML = hrs.substr(-2) + ":" + min.substr(-2) + ":" + sec.substr(-2);
				
				// Do more stuff dependent on time left
				if( hrs == '00' ) {
					warn.style.display = 'inline';
					warn.style.opacity = 1;
					if( parseInt(min) < 10 ) span.style.color = 'Orange';
					else					 span.style.color = 'Yellow';
					if( parseInt(min) < 5 ) {
						setTimeout( function() { warn.style.opacity = 0.1; }, 500 );
					}
				} else {
					warn.style.display = 'none';
					span.style.color = 'White';
				}
				
			break;
		
			// Judgement Hour timer
			case 'jh':
			
				// Get timer span element
				var span = document.getElementById('jh_timer');
				
				// Is JH active now?
				var secFirst = Math.round(Date.now()/1000) - parseInt(timestamps[0]);
				if( secFirst >= 0 && secFirst <= (this.nextJH.duration*60) ) {
					// Hide text span
					document.getElementById('jh_timer_text').style.display = 'none';
					// Get remaining time
					var remTime = Math.abs( secFirst - (this.nextJH.duration*60) );
					var remHrs = '0' + Math.floor(remTime / 60 / 60);
					var remMin = '0' + Math.floor(remTime / 60 % 60);
					var remSec = '0' + Math.floor(remTime % 60);
					if( remHrs !== '00' ) var remaining = remHrs.substr(-2) + ':' + remMin.substr(-2) + ':' + remSec.substr(-2);
					else				  var remaining = remMin.substr(-2) + ':' + remSec.substr(-2);
					// Set span text and timer
					span.innerHTML = Text.jhour + ' ' + Text.activ + '! ' + remaining;
					span.style.color = 'Yellow';
					// End here. Done.
					return true;
				} else {
					document.getElementById('jh_timer_text').style.display = 'inline';
					span.style.color = 'White';
				}
				
				// Spawn date objects
				var jhDate  = new Date(next);
				var nowDate = new Date();
				
				var jhHour = '0' + jhDate.getHours();
				var jhMins = '0' + jhDate.getMinutes();

				// Less than 24hrs -> show timer
				if( day < 1 ) {
					var spanText = hrs.substr(-2) + ":" + min.substr(-2) + ":" + sec.substr(-2);
				// More than 24hrs but tomorrow -> show tomorrow string
				} else if( jhDate.getDate() - nowDate.getDate() == 1 || (jhDate.getDate() == 1 && nowDate.getDate() == 31) ) {
					var spanText = Text.tmrrw + ", " + jhHour.substr(-2) + ":" + jhMins.substr(-2);
				// ... else, show dayOfWeek and time
				} else {
					var spanText = Daynames[jhDate.getDay()] + ", " + jhHour.substr(-2) + ":" + jhMins.substr(-2);
				}
				
				// Update text
				span.innerHTML = spanText;
				
				// Change color
				if( day < 1 && hrs == '00' ) {
					if( min < 30 ) span.style.color = 'Yellow';
				} else {
					span.style.color = 'White';
				}

			break;
			
		}
		
	};

	this.toggleDialogue = function( element_id ) {
		var element = document.getElementById(element_id);
		if( element.parentNode.style.display === 'none' ) {
			element.style.display = 'block';
			element.parentNode.style.display = 'block';
		} else {
			element.style.display = 'none';
			element.parentNode.style.display = 'none'
		}
	};
	
	this.closeDialogues = function() {
		var dialogues = document.getElementsByClassName('dialogue-window');
		for( var i = 0; i < dialogues.length; i++ ) {
			if( i === 0 ) dialogues[i].parentNode.style.display = 'none';
			dialogues[i].style.display = 'none';			
		}
	};
	
	this.openWaitDialog = function() {
		var div = $('<div><b>' + Text.waits + '<br>...<br><br></div>');
		div.append(this.loaderLarge);
		div.css('text-align', 'center');
		div.dialog({title: 'Processing ...', width: "200px", modal: true});
		return true;
	};
	
	// Update value of a slider
	this.updateSlider = function( slider, child_id ) {
		
		var target = slider.parentNode.getElementsByClassName('slider-value')[child_id];
		var value  = parseInt(slider.value);
		
		// Time values
		if( slider.name == 'duration' ) {
			
			timestring = value < 60 ? value + ' Minutes' : Math.floor(value / 60) + ' Hours, ' + (value % 60) + ' Minutes';
			target.innerHTML = timestring
			
		// Absolute values
		} else target.innerHTML = slider.value
		
		return true;
		
	};
	
	// Get current in-game time (+1000 years)
	this.getGameTime = function( dayCycle ) {
		
		var base  = 1404172800000;							// Unix-Timestamp (ms) of 1st July '14 00:00:00 UTC
		var diff  = Date.now() - base;						// Milliseconds passed since base timestamp
		var add   = diff * (24/dayCycle);					// Multiply time passed by a factor of 24/dayCycle
		var gtime = new Date( base + add + 43200000 );		// Add result to base timestamp plus additional 12 hours
		
		return gtime;										// Returns JS Date object with exact in-game time and date + 1000 years (UTC)
		
	}
	
	// Generate a weather forecast table
	this.generateWeatherForecast = function() {
		
		if( Config.weatherInfo.length < 8 ) return false;
		
		var time = this.getGameTime(Config.dayCycle);
		var wrapper = document.createElement('div');
		wrapper.innerHTML = '<b>' + Text.wfore + ':</b><br>';
		
		// Loop days
		for( var i = (this.dayOfYear+1); i < (this.dayOfYear+9); i++ ) {
			var day = i < 365 ? i : i - 365;
			// Find matching record in weatherInfo
			for( j = 0; j < Config.weatherInfo.length; j++ ) {
				if( typeof Config.weatherInfo[j] === 'undefined' ) continue;
				if( Config.weatherInfo[j].day === day ) {
					// Generate data label
					time.setUTCDate( time.getUTCDate() + 1 );
					var datestring = document.createTextNode( time.getUTCDate() + '/' + (time.getUTCMonth()+1) );
					// Generate icon
					var icon = new Image();
					icon.src = 'img/ni-weather-' + Config.weatherInfo[j].weather + '.png';
					// Translate weather
					var translated_weather = Text[Config.weatherInfo[j].weather];
					// Create wrapper and append elements
					var daywrapper = document.createElement('div');
					daywrapper.className = 'weather-forecast-item';
					daywrapper.appendChild(datestring);
					daywrapper.appendChild(document.createElement('br'));
					daywrapper.appendChild(icon);
					daywrapper.appendChild(document.createElement('br'));
					daywrapper.appendChild(document.createTextNode(translated_weather));
					wrapper.appendChild(daywrapper);
					break;
				}
			}
		}
		
		wrapper.appendChild(document.createElement('br'));
		
		// Create tooltip or update content
		if( this.weatherTooltip !== null) this.weatherTooltip.setContent = wrapper.outerHTML;
		else {
			this.weatherTooltip = new Opentip( "#header-weather", wrapper.outerHTML, { tipJoint: 'top', fixed: true, hideTriggers: ['trigger'], hideOn: 'mouseout', hideDelay: 0.7 } );
			this.weatherTooltip.show();
			this.weatherTooltip.hide();
		}
		
		// Change mouseover cursor
		document.getElementById('header-weather').style.cursor = 'help';
		
		return true;
		
	};
	
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// Object Initialization
	
	// Get JH info from server
	var jhpost = new FormData();
	jhpost.append('ajax', 'jh_info');
	ajax_send( jhpost, function(response) {
		// Try to decode JSON string
		try {
			var JHinfo = JSON.parse(response);
			if( typeof JHinfo.timestamps === 'undefined' ) return false;
			self.nextJH = JHinfo;
		} catch(e) { 
			return false; 
		}
		// If server has JH, show timer and start refresh schedule
		if( self.nextJH.timestamps.length > 0 ) {
			document.getElementById('header-jh').style.display = 'block';
			setInterval( function() { self.updateTimer('jh'); }, 1000 );
			// Create JH tooltip
			if( self.nextJH.timestamps[1] - self.nextJH.timestamps[0] < 3599*24*7 ) {
				var ttcontent = "";
				$.each( self.nextJH.timestamps, function(index, timestamp) {
					var eDate  = new Date(timestamp*1000);
					var eHour = '0' + eDate.getHours();
					var eMins = '0' + eDate.getMinutes();
					ttcontent += "<li>" + Daynames[eDate.getDay()] + ", " + eHour.substr(-2) + ":" + eMins.substr(-2) + "</li>";
				} );
				new Opentip( "#header-jh", "<b>Judgement Hours:</b><br><ul>" + ttcontent + "</ul>", { tipJoint: 'top', fixed: true, hideTriggers: ['trigger'], hideOn: 'mouseout', hideDelay: 0.7 } );
				$("#header-jh").css("cursor", "help");
			}
		}
	});
	
	// Attach event listerners to dialogue wrappers
	var dialogues = document.getElementsByClassName('dialogue-window');
	if( dialogues.length > 0 ) {
		dialogues[0].parentNode.addEventListener('click', function( e ){
			e = window.event || e; 
			if( this === e.target ) self.closeDialogues();
		});
	}
	
	// Attach event handler to sliders and update value
	var sliders = document.getElementsByClassName('slider');
	for( var i = 0; i < sliders.length; i++ ) {
		// Get child ID
		var children = sliders[i].parentNode.getElementsByClassName('slider');
		for( var child_id = 0; child_id < children.length; child_id++ ) {
			// Detect match
			if( children[child_id].name === sliders[i].name ) {
				// Spawn IIFE
				(function(child_id) {
					// Attach event handelrs
					sliders[i].onchange = function() { Master.updateSlider(this, child_id); };
					sliders[i].oninput  = function() { Master.updateSlider(this, child_id); };
					// Update vlaue initially
					self.updateSlider(sliders[i], child_id);
				})(child_id);
				break;
			}
		}
	}
	
}