<?php

if( ! defined('VERSION') ) die;

if( ! (bool)intval($config['guildmanager']) || ! isSet($_SESSION['SteamAuth']) ) $content = new Template('html/403.html');
	
else {

	# Subpages
	if( isSet($_GET['m'], $_GET['gid']) ) {
		
		$guild = new Guild( intval($_GET['gid']) );
		if( ! $guild->load() || ! $guild->is_member($_SESSION['SteamAuth']['steam_id']) ) error_redirect("index.php?livemap_id=$livemap_id&s=guildman", "Error: Failed to access guild information.");
		
				
		switch($_GET['m']) {
			
			case 'members':
				$content = new Template('html/guildman_members.html');
				
				$members = $guild->get_members();
				foreach( $members AS &$member ) {
					$member['IsLeader'] = (intval($member['ID']) === $guild->leader_char_id);
					$member['GenderIcon'] = intval($member['Gender']) === 1 ? 'ni-male.png' : 'ni-female.png';
					$member['GuildRoleName'] = intval($member['Gender']) === 1 ? $guild_ranks_m[intval($member['GuildRoleID'])] : $guild_ranks_f[intval($member['GuildRoleID'])] ;
				}
				$content->assign('members', $members);
				
				$ranks_m = array();
				foreach( $guild_ranks_m AS $id => $name ) if( $id > 1 ) $ranks_m[] = array( 'id' => $id, 'name' => $name );
				$content->assign('ranks_m', $ranks_m);
				
				$ranks_f = array();
				foreach( $guild_ranks_f AS $id => $name ) if( $id > 1 ) $ranks_f[] = array( 'id' => $id, 'name' => $name );
				$content->assign('ranks_f', $ranks_f);
				
				$content->assign('isAdmin', $guild->is_admin($_SESSION['SteamAuth']['steam_id']));
				
			break;
			
			case 'standings':
				$content = new Template('html/guildman_standings.html');
				
				$standings = $guild->get_standings();
				foreach( $standings AS &$standing ) {
					$standing['GuildTier'] = Guild::get_claim_tier( intval($standing['Radius']) );
					$standing['GuildTierName'] = $claim_tiers[$standing['GuildTier']];
					$standing['GuildType'] = $guild_types[intval($standing['GuildTypeID'])];
					$standing['LeaderGenderIcon'] = intval($standing['LeaderGender']) === 1 ? 'ni-male.png' : 'ni-female.png';
					$standing['Distance'] = round( Livemap::get_distance($guild->center_geoid, intval($standing['CenterGeoID'])) * 2);
					$standing_id = intval($standing['OurStanding']);
					$standing['OurStandingColor'] = Guild::$standing_color[$standing_id];
					$standing['OurStandingString'] = $guild_standings[$standing_id];
					$standing_id = intval($standing['TheirStanding']);
					$standing['TheirStandingColor'] = Guild::$standing_color[$standing_id];
					$standing['TheirStandingString'] = $guild_standings[$standing_id];
				}
				$content->assign('guilds', $standings);
				
				$standing_types = array();
				for( $i = 1; $i <= 5; $i++ ) $standing_types[] = array( 'id' => $i, 'name' => $guild_standings[$i], 'color' => Guild::$standing_color[$i] );
				$content->assign('standings', $standing_types);
				
				$content->assign('isLeader', ($guild->leader_steam_id === $_SESSION['SteamAuth']['steam_id']));
				$content->assign('isAdmin', $guild->is_admin($_SESSION['SteamAuth']['steam_id']));

			break;
			
			case 'permissions':
				$content = new Template('html/guildman_permissions.html');
				
				if( ! $guild->is_admin($_SESSION['SteamAuth']['steam_id']) ) error_redirect("index.php?livemap_id=$livemap_id&s=guildman", "Only leaders can see and edit permissions.");
				
				$ranks = $guild->get_rank_permissions();
				foreach( $ranks AS &$subject ) {
					$subject['CanEnterIcon']   = (bool)intval($subject['CanEnter'])   ? 'icon_check.png' : 'icon_error.png';
					$subject['CanBuildIcon']   = (bool)intval($subject['CanBuild'])   ? 'icon_check.png' : 'icon_error.png';
					$subject['CanClaimIcon']   = (bool)intval($subject['CanClaim'])   ? 'icon_check.png' : 'icon_error.png';
					$subject['CanUseIcon']     = (bool)intval($subject['CanUse'])     ? 'icon_check.png' : 'icon_error.png';
					$subject['CanDestroyIcon'] = (bool)intval($subject['CanDestroy']) ? 'icon_check.png' : 'icon_error.png';
					$subject['GuildRoleName']  = $guild_ranks_m[intval($subject['GuildRoleID'])];
					$subject['IsEditable']     = (intval($subject['GuildRoleID']) > 1);
				}
				$content->assign('ranks', $ranks);
				unset($subject);
				
				$standings = $guild->get_standing_permissions();
				foreach( $standings AS &$subject ) {
					$subject['CanEnterIcon']   = (bool)intval($subject['CanEnter'])   ? 'icon_check.png' : 'icon_error.png';
					$subject['CanBuildIcon']   = (bool)intval($subject['CanBuild'])   ? 'icon_check.png' : 'icon_error.png';
					$subject['CanClaimIcon']   = (bool)intval($subject['CanClaim'])   ? 'icon_check.png' : 'icon_error.png';
					$subject['CanUseIcon']     = (bool)intval($subject['CanUse'])     ? 'icon_check.png' : 'icon_error.png';
					$subject['CanDestroyIcon'] = (bool)intval($subject['CanDestroy']) ? 'icon_check.png' : 'icon_error.png';
					$subject['ColorCode']	   = Guild::$standing_color[intval($subject['StandingTypeID'])];
					$subject['StandingName']   = $guild_standings[intval($subject['StandingTypeID'])];
				}
				$content->assign('standings', $standings);
				unset($subject);
				
				$guilds = $guild->get_guild_permissions();
				foreach( $guilds AS &$subject ) {
					$subject['CanEnterIcon']   = (bool)intval($subject['CanEnter'])   ? 'icon_check.png' : 'icon_error.png';
					$subject['CanBuildIcon']   = (bool)intval($subject['CanBuild'])   ? 'icon_check.png' : 'icon_error.png';
					$subject['CanClaimIcon']   = (bool)intval($subject['CanClaim'])   ? 'icon_check.png' : 'icon_error.png';
					$subject['CanUseIcon']     = (bool)intval($subject['CanUse'])     ? 'icon_check.png' : 'icon_error.png';
					$subject['CanDestroyIcon'] = (bool)intval($subject['CanDestroy']) ? 'icon_check.png' : 'icon_error.png';
				}
				$content->assign('guilds', $guilds);
				$content->assign('has_guilds', !empty($guilds));
				unset($subject);
				
				$chars = $guild->get_char_permissions();
				foreach( $chars AS &$subject ) {
					$subject['CanEnterIcon']   = (bool)intval($subject['CanEnter'])   ? 'icon_check.png' : 'icon_error.png';
					$subject['CanBuildIcon']   = (bool)intval($subject['CanBuild'])   ? 'icon_check.png' : 'icon_error.png';
					$subject['CanClaimIcon']   = (bool)intval($subject['CanClaim'])   ? 'icon_check.png' : 'icon_error.png';
					$subject['CanUseIcon']     = (bool)intval($subject['CanUse'])     ? 'icon_check.png' : 'icon_error.png';
					$subject['CanDestroyIcon'] = (bool)intval($subject['CanDestroy']) ? 'icon_check.png' : 'icon_error.png';
				}
				$content->assign('chars', $chars);
				$content->assign('has_chars', !empty($chars));
				unset($subject);
				
				$all_chars = $server->get_characters();
				foreach( $all_chars AS &$c ) {
					unset($c['SteamID']);
					unset($c['AccountID']);
					unset($c['gender']);
					unset($c['GuildID']);
					unset($c['GuildRoleId']);
				}
				unset($c);
				
				$content->assign('json_guilds', json_encode($server->get_guilds()) );
				$content->assign('json_chars', json_encode($all_chars) );
				
			break;
			
		}
		
		$content->assign( 'MyGuildID', $guild->id );
		$content->assign( 'MyGuildName', htmlspecialchars($guild->name) );
		
	}
	
	# Guild Selection Page
	if( ! isSet($content) ) {
		
		$content = new Template('html/guildman.html');
	
		// Get own characters
		$mychars = $server->get_steam_characters($_SESSION['SteamAuth']['steam_id']);
		foreach( $mychars AS $key => &$char ) {
			// Skip other chars if CharID is set in session (GuildGUI)
			if( isSet($_SESSION['CharID']) && $_SESSION['CharID'] !== intval($char['ID']) ) {
				unset($mychars[$key]);
				continue;
			}
			// Gender Icon
			$char['GenderIcon'] = intval($char['gender']) === 1 ? 'ni-male.png' : 'ni-female.png';
			// Has guild?
			if( $char['has_guild'] = (bool)intval($char['GuildID']) ) {
				$guild = new Guild( intval($char['GuildID']) );
				$guild->load();
				$char['has_claim'] = (bool)intval($char['Radius']);
				$char['isAdmin'] = $guild->is_admin($_SESSION['SteamAuth']['steam_id']);
				$char['GuildRoleName'] = intval($char['gender']) === 1 ? $guild_ranks_m[intval($char['GuildRoleID'])] : $guild_ranks_f[intval($char['GuildRoleID'])];
				$char['GuildTier'] = Guild::get_claim_tier(intval($char['Radius']));
				$char['GuildTierName'] = $claim_tiers[$char['GuildTier']];
				$char['GuildType'] = $guild_types[$guild->type];
				$charter = $guild->get_detail('GuildCharter');
				$char['GuildCharter'] = strlen($charter) > 1 ? nl2br(htmlspecialchars($charter)) : '---';
				$char['GuildCharterPublic'] = intval( $guild->get_detail('GuildCharterPublic') );
				$char['MemberCount'] = count($guild->get_members());
				$char['Founded'] = $guild->founded;
			}
		}

		$content->assign( 'characters', $mychars );
		$content->assign( 'guilds', $server->get_guilds() );
		$content->assign( 'JSON_STANDINGS', json_encode($guild_standings) );
		
	}

}

// Show ads?
$content->assign( 'SHOW_ADS', ( $config['isttmap'] && ! (isSet($_SESSION['InGame']) && $_SESSION['InGame']) ) );

// Ingame view ? Overwrite main template
$content->assign( 'INGAME', (isSet($_SESSION['InGame']) && $_SESSION['InGame']) );
if( isSet($_SESSION['InGame']) && $_SESSION['InGame'] ) {
	$html = new Template('html/main_ingame.html');
}
