<?php

	// End if this file wasn't included by index.php
	if( ! isSet($config, $cdb, $livemap_id) ) die;

	$rev = intval($config['script_revision']);
	switch($rev) {
		
		// Installation
		case 0:
		
			$cdb->query( "DROP TABLE IF EXISTS nyu_livemap, nyu_livemap_groups" );
		
			$cdb->query( "CREATE TABLE `nyu_livemap` (
							`ID` TINYINT(3) UNSIGNED NOT NULL,
							`script_revision` TINYINT(1) UNSIGNED NOT NULL DEFAULT '1',
							`server_query` TINYINT(1) UNSIGNED NOT NULL DEFAULT '1',
							`title` VARCHAR(60) NOT NULL DEFAULT 'New Livemap',
							`homepage` VARCHAR(255) NOT NULL DEFAULT '',
							`language` CHAR(2) NOT NULL DEFAULT 'en',
							`timezone` VARCHAR(40) NOT NULL DEFAULT 'Europe/London',
							`daycycle` FLOAT(3,1) UNSIGNED NOT NULL DEFAULT '3.0',
							`restarts` VARCHAR(60) NOT NULL DEFAULT '',
							`alt_map` TINYINT(1) NOT NULL DEFAULT '0',
							`file_revision` SMALLINT(5) UNSIGNED NOT NULL DEFAULT '1',
							`color_bg` CHAR(6) NOT NULL DEFAULT '001B36',
							`color_claim` CHAR(6) NOT NULL DEFAULT 'FFFF00',
							`color_label` CHAR(6) NOT NULL DEFAULT 'FFFFFF',
							`style_claim` VARCHAR(10) NOT NULL DEFAULT 'solid',
							`style_tooltip` VARCHAR(10) NOT NULL DEFAULT 'standard',
							`width_claim` TINYINT(1) UNSIGNED NOT NULL DEFAULT '2',
							PRIMARY KEY (`ID`)
						) COLLATE='utf8_general_ci'" );
						
			$cdb->query( "CREATE TABLE `nyu_livemap_groups` (
							`ID` SMALLINT(5) UNSIGNED NOT NULL AUTO_INCREMENT,
							`livemap_id` MEDIUMINT(8) UNSIGNED NOT NULL,
							`type_id` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0' COMMENT '0 = Custom, 1 = Anonymous, 2 = GMs',
							`name` VARCHAR(50) NOT NULL,
							`tag` VARCHAR(3) NOT NULL DEFAULT '',
							`tag_color` CHAR(6) NOT NULL DEFAULT 'FFFFFF',
							`password` VARCHAR(64) NOT NULL DEFAULT '',
							`privileges` SMALLINT(5) UNSIGNED NOT NULL DEFAULT '0',
							`members_csv` TEXT NOT NULL,
							PRIMARY KEY (`ID`)
						) COLLATE='utf8_general_ci'" );
						
			$cdb->query( "INSERT INTO nyu_livemap (ID) VALUES ($livemap_id)" );
			$cdb->query( "INSERT INTO nyu_livemap_groups (livemap_id, type_id, name, tag, tag_color, privileges, members_csv) VALUES ($livemap_id, 1, 'Anonymous visitor', '', '', 3631,''), (1, 2, 'Game Masters', 'GM', 'FF0000', 4095, '')" );
			
		case 1:
			// with 2.2.0
			$cdb->query( "ALTER TABLE `nyu_livemap` ADD `font_claimlabel` VARCHAR(255) NOT NULL DEFAULT 'Georgia' AFTER `width_claim`, ADD `font_claimdetail` VARCHAR(255) NOT NULL DEFAULT 'Georgia' AFTER `font_claimlabel`" );
			$cdb->query( "UPDATE nyu_livemap_groups SET privileges = privileges + 32768 WHERE livemap_id = '$livemap_id'" );
			$cdb->query( "UPDATE nyu_livemap SET script_revision = 2 WHERE ID = '$livemap_id'" );
			
		case 2:
			// with 2.3.0 beta
			$cdb->query( "ALTER TABLE `nyu_livemap_groups` CHANGE `privileges` `privileges` INT(10) UNSIGNED NOT NULL DEFAULT '0'" );
			$cdb->query( "ALTER TABLE `nyu_livemap` ADD `guildmanager` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0' AFTER `file_revision`" );
			$cdb->query( "UPDATE nyu_livemap SET script_revision = 3 WHERE ID = '$livemap_id'" );
			
		case 3:
			// with 2.3.0 final
			$cdb->query( "DROP TABLE IF EXISTS nyu_livemap_sessions" );
			$cdb->query( "CREATE TABLE `nyu_livemap_sessions` (
							`ID` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
							`SteamID` BIGINT(20) UNSIGNED NOT NULL,
							`Token` CHAR(32) NOT NULL,
							`Expires` DATETIME NOT NULL,
							PRIMARY KEY (`ID`)
						) COLLATE='utf8_general_ci'" );
			$cdb->query( "UPDATE nyu_livemap SET script_revision = 4 WHERE ID = '$livemap_id'" );
			
		case 4:
			// with 2.4.0
			$cdb->query( "CREATE TABLE IF NOT EXISTS `nyu_livemap_log` (
							 `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
							 `livemap_id` mediumint(8) unsigned NOT NULL,
							 `user_group` varchar(50) NOT NULL,
							 `action` varchar(30) NOT NULL,
							 `detail` varchar(255) NOT NULL,
							 `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
							 PRIMARY KEY (`ID`)
						) COLLATE='utf8_general_ci'" );
			$cdb->query( "UPDATE nyu_livemap SET script_revision = 5 WHERE ID = '$livemap_id'" );

		case 5:
			// with 2.5.0
			$cdb->query( "ALTER TABLE `nyu_livemap`
				CHANGE COLUMN `color_claim` `color_claim_t1` CHAR(6) NOT NULL DEFAULT 'FFFF00' AFTER `color_bg`,
				ADD `color_claim_t2` CHAR(6) NOT NULL DEFAULT 'FFFF00' AFTER `color_claim_t1`, 
				ADD `color_claim_t3` CHAR(6) NOT NULL DEFAULT 'FFFF00' AFTER `color_claim_t2`, 
				ADD `color_claim_t4` CHAR(6) NOT NULL DEFAULT 'FFFF00' AFTER `color_claim_t3`,
				ADD `discord` VARCHAR(255) NOT NULL AFTER `homepage`, 
				ADD `teamspeak` VARCHAR(100) NOT NULL AFTER `discord`" );
			$cdb->query( "UPDATE `nyu_livemap` SET color_claim_t2 = color_claim_t1, color_claim_t3 = color_claim_t1, color_claim_t4 = color_claim_t1" );
			$cdb->query( "UPDATE `nyu_livemap` SET script_revision = 6 WHERE ID = '$livemap_id'" );
		
		case 6:
			// with 2.6.3
			$cdb->query( "ALTER TABLE `nyu_livemap` ADD `geo_cache_version` INT(10) NOT NULL DEFAULT '0' AFTER `font_claimdetail`" );
			$cdb->query( "UPDATE `nyu_livemap` SET script_revision = 7 WHERE ID = '$livemap_id'" );
			
		case 7:
			// with 2.7.0
			$cdb->query( "UPDATE nyu_livemap_groups SET `privileges` = `privileges` + 262144 WHERE livemap_id = '$livemap_id'" );
			$cdb->query( "UPDATE `nyu_livemap` SET script_revision = 8 WHERE ID = '$livemap_id'" );
		
		case 8:
			// with 2.7.1
			$cdb->query( "UPDATE nyu_livemap_groups SET `privileges` = `privileges` + 1048576 WHERE `privileges` & 16384 = 16384 AND livemap_id = '$livemap_id'" );
			$cdb->query( "UPDATE `nyu_livemap` SET script_revision = 9 WHERE ID = '$livemap_id'" );

	}

	session_destroy();
	sleep(1);
	header("Location: index.php");
	die;

?>