<?php

	if( ! defined('VERSION') ) die;
	const TTMOD_VERSION = 1.3;
	
	date_default_timezone_set($config['timezone']);
	
	require_once('includes/libs/SourceQuery.php');
	require_once('includes/gameserver.class.php');
	require_once('includes/livemap.class.php');
	require_once('includes/guild.class.php');
	require_once('includes/functions.php');
	
	// Detect login and set privileges
	$_SESSION['login'] = isSet($_SESSION['login']) ? $_SESSION['login'] : FALSE;
	if( $_SESSION['login'] ) $mygroup = unserialize($_SESSION['mygroup']);
	else $mygroup = new Group( $groups[0]['ID'], $groups[0]['name'], $groups[0]['privileges'] );
	
	// Create server object
	$server = new LiFServer($config['game_ip'], $config['game_port'], (bool)$config['server_query']);

	// Configure livemap class
	Livemap::configure( $config, $cdb, $mygroup );
	
	// AJAX Request Handlers
	if( isSet($_REQUEST['ajax']) ) require_once('includes/ajax.handler.php');

	// Include translations
	require_once('locale.php');
	
	// POST & GET Request Handlers
	if( isSet($_REQUEST['action']) ) require_once('includes/action.handler.php');
	
	// Steam Auth through cookie
	if( ! isSet($_SESSION['SteamAuth']) && isSet($_COOKIE['SteamAuth']) ) {
		$in_cookie  = unserialize($_COOKIE['SteamAuth']);
		$in_steamid = $cdb->esc($in_cookie[0]);
		$in_token	= $cdb->esc($in_cookie[1]);
		$rs = $cdb->query( "SELECT * FROM {$config['table_s']} WHERE SteamID = '$in_steamid' AND Token = '$in_token' AND Expires > NOW()" );
		if( ! empty($rs) ) $_SESSION['SteamAuth'] = array('steam_id' => $in_steamid);
	}

	// Initialize main template
	require_once('includes/template.class.php');
	$html = new Template('html/main.html');

	############################################################################################################################################
	#
	#  Fill content page
	#
	
	$site = isSet($_GET['s']) ? $_GET['s'] : 'main';
	
	switch( $site ) {
		
		case 'conf':
		
			// Ensure we're admin
			if( ! $mygroup->admin ) {
				$content = new Template('html/403.html');
				break;
			}
			
			// Modify group details
			foreach( $groups AS &$group ) {
				$g = new Group( $group['ID'], $group['name'], $group['privileges'] );
				$group['protected'] = (intval($group['type_id']) > 0);
				$loginstring = (bool)strlen($group['password']) ? 'Yes' : 'No';
				$group['login_str'] = $group['type_id'] === '1' ? '---' : $loginstring;
				$group['has_tag'] = (bool)strlen($group['tag']);
				$group['privileges'] = array();
				if( $group['type_id'] === '1' || (bool)strlen($group['password']) ) foreach( $g->get_privilege_list(TRUE) AS $priv ) $group['privileges'][] = array( 'priv_name' => $priv[0] );
			}
			
			// Prepare languages
			$languages = array();
			foreach( Livemap::$languages AS $key => $name ) {
				$languages[] = array('shortcut' => $key, 'name' => $name, 'selected' => (Livemap::$language === $key) );
			}
			
			// Fill content template
			$content = new Template('html/conf.html');
			// Assign config
			foreach( $config AS $key => $val ) $content->assign( $key, $val );
			$content->assign( 'languages', $languages );
			// Assign styles
			$claimstyles = array( 'solid', 'dashed', 'dotted', 'double' );
			$content->assign( 'claimstyles', simple_select($claimstyles, $config['style_claim']) );
			$claimborder = array( '1', '2', '3', '4', '5' );
			$content->assign( 'claimthickness', simple_select($claimborder, $config['width_claim']) );
			$tooltips = array( 'standard', 'dark', 'alert', 'glass' );
			$content->assign( 'tooltips', simple_select($tooltips, $config['style_tooltip']) );
			// Assign timezones
			$content->assign( 'timezones', simple_select(timezone_identifiers_list(), $config['timezone']) );
			// Assign groups
			$content->assign( 'groups', $groups );
			// Assign weatherfile info
			$is_default = ( $config['isttmap'] && ! file_exists("weather/{$livemap_id}_weather.xml") );
			$content->assign( 'DEFAULT_WEATHER', $is_default );
			// Guild Manager
			$content->assign( 'guildmanager', (bool)intval($config['guildmanager']) );
			
			// GuildGUI URL
			$actual_link = ( isSet($_SERVER['HTTPS']) ? "https" : "http" ) . "://$_SERVER[HTTP_HOST]/index.php?livemap_id=$livemap_id&action=GuildGUI";
			$content->assign( 'GuildGUI_URL', $actual_link );
			
			// Get PHP/Webserver info
			$arch_hint   = "";
			$arch_string = "64-Bit";
			$arch_ok     = TRUE;
			if( 2147483647 === PHP_INT_MAX ) {
				$arch_string = "32-Bit";
				$arch_hint   = "Some features require 64-Bit PHP or the GMP extension enabled.";
				$arch_ok    = FALSE;
				if( extension_loaded('gmp') ) {
					$arch_string .= " with GMP-Extension enabled";
					$arch_ok     = TRUE;
					$arch_hint   = "";
				}
			}
			$content->assign( 'PHP_VERSION', PHP_VERSION );
			$content->assign( 'PHP_OS_FAMILY', PHP_OS );
			$content->assign( 'PHP_ARCH_TEXT', $arch_string );
			$content->assign( 'PHP_ARCH_ICON', $arch_ok ? 'icon_check.png' : 'icon_error.png' );
			$content->assign( 'PHP_ARCH_HINT', $arch_hint );
			$content->assign( 'ALLOW_FSOCKOPEN', strpos(ini_get('disable_functions'), 'fsockopen') === false );
			
			// Get last TTmod heartbeat and version
			if( $server->detect_servermod() ) {
				$ttmod_version = $server->get_servermod_version();
				$rs = $server->passthru_db_query( "SELECT UNIX_TIMESTAMP() - UNIX_TIMESTAMP(MAX(`time`)) AS diff FROM nyu_tracker_stats", FALSE );
				$content->assign( 'ttmod_sec', $rs['diff'] );
				$content->assign( 'ttmod_healthy', (intval($rs['diff']) < 60*6 ) );
				$content->assign( 'ttmod_version', $ttmod_version );
				$content->assign( 'ttmod_up2date', (floatval($ttmod_version) >= TTMOD_VERSION) );
			}
			
			// Assign fonts
			$content->assign( 'fonts_claimlabel', simple_select(Livemap::get_font_names(), $config['font_claimlabel']) );
			$content->assign( 'fonts_claimdetail', simple_select(Livemap::get_font_names(), $config['font_claimdetail']) );
			// Load all fonts, lol
			foreach( Livemap::$fonts AS $font ) Livemap::load_font( $font['name'] );
			
			// Get logs
			$logs = $cdb->query( "SELECT ID, user_group, timestamp, action, detail FROM {$config['table_l']} WHERE livemap_id = $livemap_id ORDER BY ID DESC" );
			foreach( $logs AS &$log ) {
				// Get module
				$parts = explode('_', $log['action']);
				switch($parts[0]) {
					case 'config':	$log['module'] = 'Livemap Config';			break;
					case 'chman':	$log['module'] = 'Character Management';	break;
					case 'rcon':	$log['module'] = 'RCON Console';			break;
					case 'group':	$log['module'] = 'User Groups';				break;
				}
				// Translate action key
				switch($log['action']) {
					case 'config_general':		$log['action'] = 'General livemap configuration was changed';		break;
					case 'config_appearance':	$log['action'] = 'Livemap appearance configuration was changed';	break;
					case 'chman_delete':		$log['action'] = 'Characters were deleted';							break;
					case 'chman_ban':			$log['action'] = 'Accounts were banned';							break;
					case 'chman_unban':			$log['action'] = 'Accounts were unbanned';							break;
					case 'chman_disable':		$log['action'] = 'Characters were disabled';						break;
					case 'chman_enable':		$log['action'] = 'Characters were enabled';							break;
					case 'chman_align':			$log['action'] = 'Characters alignments were changed';				break;
					case 'chman_rename':		$log['action'] = 'Renamed character';								break;
					case 'chman_item':			$log['action'] = 'Insert item to players inventory (Char. Man.)';	break;
					case 'chman_makegm':		$log['action'] = 'Accounts were promoted to permanent GMs';			break;
					case 'rcon_message_all':	$log['action'] = 'Message to all players';							break;
					case 'rcon_teleport':		$log['action'] = 'A player was teleported';							break;
					case 'rcon_teleport_all':	$log['action'] = 'All players were teleported';						break;
					case 'rcon_exec_function':	$log['action'] = 'Execute server function';							break;
					case 'rcon_exec_command':	$log['action'] = 'Execute custom server command';					break;
					case 'rcon_kick_player':	$log['action'] = 'Player kicked from server';						break;
					case 'rcon_ban_player':		$log['action'] = 'Player banned from server';						break;
					case 'rcon_message_player':	$log['action'] = 'Message sent to player';							break;
					case 'rcon_insert_item':	$log['action'] = 'Insert item to players inventory (RCON)';			break;
					case 'group_add':			$log['action'] = 'New user group was added';						break;
					case 'group_edit':			$log['action'] = 'User group was edited';							break;
					case 'group_delete':		$log['action'] = 'User group was deleted';							break;
				}
			}
			$content->assign( 'json_logs', json_encode($logs) );
			
			// Security check: updater exists?
			$content->assign( "UPDATER_EXISTS", ( ! $config['isttmap'] && file_exists("includes/updater.php") ) );
			
			$include_tabulator = TRUE;
			
		break;
		
		case 'group':
		
			// Ensure we're admin
			if( ! $mygroup->admin ) {
				$content = new Template('html/403.html');
				break;
			}
		
			$newgroup = ! isSet($_GET['id']);
			if( ! $newgroup ) {
				$groupinfo = FALSE;
				foreach( $groups AS $group ) if( intval($group['ID']) === intval($_GET['id']) ) $groupinfo = $group;
			}
			if( $newgroup || ! $groupinfo ) {
				$groupinfo = array( 'ID' => 0, 'name' => '', 'tag_color' => '3333FF', 'tag' => '', 'password' => '', 'members_csv' => '', 'privileges' => 1, 'type_id' => '0' );
			}
			
			// Privileges array
			$thisgroup = new Group( $groupinfo['ID'], $groupinfo['name'], $groupinfo['privileges'] );
			$allprivs  = array();
			foreach( $thisgroup->privileges AS $name => $bool ) {
				$translated = $thisgroup->translate_privilege($name);
				$allprivs[] = array( 'key'  => $name, 'isset' => $bool, 'name' => $translated[0], 'descr' => $translated[1] );
			}
			
			// Members
			$members = $server->get_character_info( $groupinfo['members_csv'] );
			$members_static = $groupinfo['type_id'] === '2' ? $server->get_gm_characters() : array();
			
			// Fill content template
			$content = new Template('html/group.html');
			$content->assign( 'name', htmlspecialchars($groupinfo['name']) );
			$content->assign( 'group_id', htmlspecialchars($groupinfo['ID']) );
			$content->assign( 'login', (bool)strlen($groupinfo['password']) );
			$content->assign( 'tag', (bool)strlen($groupinfo['tag']) );
			$content->assign( 'tag_name', htmlspecialchars($groupinfo['tag']) );
			$content->assign( 'tag_color', htmlspecialchars($groupinfo['tag_color']) );
			$content->assign( 'visitor', ($groupinfo['type_id'] === '1') );
			$content->assign( 'protected', ($groupinfo['type_id'] !== '0') );
			$content->assign( 'privs', $allprivs );
			$content->assign( 'members', $members );
			$content->assign( 'members_static', $members_static );
			$content->assign( 'characters', $server->get_characters() );
		
		break;
		
		// Account & Character Management
		case 'char':
		
			// Check permissions
			if( ! $mygroup->privileges['manage_chars'] ) {
				$content = new Template('html/403.html');
				break;
			}
			
			// Load template
			$content = new Template('html/chman.html');	
			
			// Include JS libraries
			$include_tabulator = TRUE;
		
			// Assign char list
			$charlist = $server->get_characters_list();
			$content->assign( 'characters', json_encode($charlist) );
			
			// Item list
			$content->assign( 'items', $server->get_all_items() );

			// Assign statistics
			$content->assign( 'tracker_start', $server->get_stat_info('tracker_first') );
			$content->assign( 'tracker_end', $server->get_stat_info('tracker_last') );
			$content->assign( 'chars_total', $server->get_stat_info('chars_total') );
			
			// TTmod version
			$ttmod_version = $server->get_servermod_version();
			$content->assign( 'ttmod_up2date', (floatval($ttmod_version) >= TTMOD_VERSION) );
			$content->assign( 'show_ttmod_warning', (floatval($ttmod_version) < TTMOD_VERSION) );
			
			// Translations
			$ranks = array( $guild_ranks_m, $guild_ranks_f );
			$content->assign( 'json_ranks', json_encode($ranks) );
			
		break;
		
		// RCON
		case 'rcon':
			
			// Ensure server mod is installed
			if( ! $server->detect_servermod() ) {
				$content = new Template('html/rcon_404.html');
				break;
			}
		
			$content = $mygroup->privileges['rcon'] ? new Template('html/rcon.html') : new Template('html/403.html');
			
			$content->assign( 'items', $server->get_all_items() );
			
			$ttmod_version = $server->get_servermod_version();
			$content->assign( 'show_ttmod_warning', (floatval($ttmod_version) < TTMOD_VERSION) );

		break;

		// Guild Management & GuildGUI
		case 'guildman':
			
			require_once('includes/guildgui.php');
			
		break;
		
		// Main Livemap
		case 'main':
		default: 
		
			$content = new Template('html/map.html');
			
			// Get claims, chars and structures
			$claims		= $mygroup->privileges['claims'] ? $server->get_claims() : array();
			$outposts	= $mygroup->privileges['outposts'] ? $server->get_outposts() : array();
			$pclaims	= $mygroup->privileges['pclaim_layer'] ? $server->get_personal_claims() : array();
			$aclaims	= $mygroup->privileges['aclaim_layer'] ? $server->get_admin_lands() : array();
			$claims_js  = array();
			$standings  = $mygroup->privileges['standings'] ? $server->get_guild_standings() : array();
			$characters = $server->get_characters();
			$gm_chars   = $server->get_gm_characters();
			$buildings  = $mygroup->privileges['struct_count'] ? $server->get_structures() : array();
			$tradeposts = $mygroup->privileges['trading_posts'] ? $server->get_tradeposts() : array();
			
			// Loop through all guild claims
			foreach( $claims AS $i => &$claim ) {
				
				// Get pixel position of guild claim CENTER
				$d = intval($claim['Radius']);
				$r = intval(ceil($d/2));
				$coords = Livemap::terpos2pixelpos( $claim['TerID'], $claim['x'], $claim['y'] );
				$cenX = $coords[0];
				$cenY = $coords[1];
				$domX = $cenX - $r - intval($config['width_claim']);
				$domY = $cenY - $r - intval($config['width_claim']);
				
				// Escape HTML characters 
				$claim['name'] = htmlentities($claim['guild']);
				
				// Center the label or place on top?
				$center = center_guild_label($claim['name'], $d);
				
				// Assign positions and dimensions for claim
				$claim['d'] = $d;
				$claim['r'] = $r;
				$claim['centerx'] = $cenX;
				$claim['centery'] = $cenY;
				$claim['cx'] = $domX;
				$claim['cy'] = $domY;
				$claim['class']  = $center ? 'guild-name-center' : 'guild-name-top';
				$claim['lsize']  = $center ? $d - 8 : 250;
				$claim['lx'] 	 = $center ? $domX + 4 : $cenX - ($claim['lsize']/2);
				$claim['ly']	 = $center ? $domY : $domY - 22;
				$claim['height'] = $center ? "height: {$d}px;" : "";
				
				// Process founding time
				$ftime = strtotime($claim['ctime']);
				switch( Livemap::$language ) {
					case 'de':	$claim['founded'] = date('d.m.Y, H:i', $ftime) . " Uhr";	break;
					case 'fr':	$claim['founded'] = date("d.m.Y, H\hi", $ftime) . " heure";	break;
					case 'ru':	$claim['founded'] = date('d.m.Y, H:i ', $ftime);			break;
					default:	$claim['founded'] = date('Y-m-d, H:i', $ftime);
				}
				
				// Calculate guild tier (1-4)
				$claim['GuildTier'] = Guild::get_claim_tier($d);
				$claim['ClaimTierName'] = $claim_tiers[$claim['GuildTier']];
				
				// Unpack charter info
				$charter_data = json_decode($claim['GuildCharter'], TRUE);
				$public_charter = ( isSet($charter_data['GuildCharterPublic']) && $charter_data['GuildCharterPublic'] );
				$claim['GuildCharterPublic'] = $public_charter;
				
				// Build member list
				$claim['members'] = array();
				foreach( $characters AS $j => $character ) {
					// is member?
					if( $character['GuildID'] === $claim['GuildID'] ) {
						// is Leader ?
						$character['member_type'] = intval($character['GuildRoleId']) === 1 ? 'Leader' : 'Member';
						$character['GuildRoleName'] = intval($character['gender']) === 1 ? $guild_ranks_m[intval($character['GuildRoleId'])] : $guild_ranks_f[intval($character['GuildRoleId'])];
						// is member of tagged group?
						$character['tags'] = array();
						foreach( $groups AS $group ) {
							// Skip no-tag groups
							if( strlen($group['tag_color']) === 0 ) continue;
							// Detect static GMs
							$force = FALSE;
							if( $group['type_id'] === '2' ) foreach($gm_chars AS $gm_char) if($gm_char['ID'] === $character['CharID']) $force = TRUE;
							// Find configured group members
							$char_ids = str_getcsv($group['members_csv']);
							if( in_array($character['CharID'], $char_ids) || $force ) {
								$character['tags'][] = array( 
									'tag' => htmlspecialchars($group['tag']),
									'tag_name' => htmlspecialchars($group['name']),
									'tag_color' => htmlspecialchars($group['tag_color'])
								);
							}
						}
						// Escape special chars
						$character['FullName'] = htmlentities($character['FirstName']) . ' ' . htmlentities($character['LastName']);
						// Append char to members array
						$claim['members'][] = $character;
						unset($characters[$j]);
					}
				}
				
				$claim['mcount'] = count($claim['members']);
				$claim['bcount'] = 0;
				
				// Push to JS claims array
				$claims_js[] = array(
					'id' => intval($claim['GuildID']),
					'name' => $claim['name'],
					'radius' => $r,
					'center_x' => $cenX,
					'center_y' => $cenY,
					'charter' => $public_charter ? nl2br(htmlentities($charter_data['GuildCharter'])) : ''
				);

			}
			
			// Calculate building count for guild claims
			if( $mygroup->privileges['struct_count'] ) {
				foreach( $buildings AS $b ) {
					foreach( $claims AS &$c ) {
						$dx = $c['centerx'] - $b[0];
						$dy = $c['centery'] - $b[1];
						if( hypot($dx, $dy) <= $c['r'] ) {
							$c['bcount']++;
							break;
						}
					}
				}
			}
			
			// Prepare personal claims
			foreach( $pclaims AS &$pclaim ) {
				$coords_nw = Livemap::terpos2pixelpos( $pclaim['TerID1'], $pclaim['x1'], $pclaim['y1'] );
				$coords_se = Livemap::terpos2pixelpos( $pclaim['TerID2'], $pclaim['x2'], $pclaim['y2'] );
				$pclaim['x'] = $coords_nw[0];
				$pclaim['y'] = $coords_nw[1];
				$pclaim['width']  = abs($coords_se[0] - $coords_nw[0]) + 1;
				$pclaim['height'] = abs($coords_se[1] - $coords_nw[1]) + 1;
				$pclaim['owner']  = "{$pclaim['Name']} {$pclaim['LastName']}"; 
			}
			// Prepare admin lands
			foreach( $aclaims AS &$aclaim ) {
				$coords_nw = Livemap::terpos2pixelpos( $aclaim['TerID1'], $aclaim['x1'], $aclaim['y1'] );
				$coords_se = Livemap::terpos2pixelpos( $aclaim['TerID2'], $aclaim['x2'], $aclaim['y2'] );
				$aclaim['x'] = $coords_nw[0];
				$aclaim['y'] = $coords_nw[1];
				$aclaim['width']  = abs($coords_se[0] - $coords_nw[0]) + 1;
				$aclaim['height'] = abs($coords_se[1] - $coords_nw[1]) + 1;
			}
			// Prepare outposts
			$shapes = [ 1711 => 'mm-swords.png', 1710 => 'mm-cuffs.png', 1709 => 'mm-garden.png', 1708 => 'mm-cow.png', 1707 => 'mm-windmill.png', 1706 => 'mm-mushrooms.png', 1705 => 'mm-quarry.png', 1704 => 'mm-saw.png', 1703 => 'mm-herbal.png', 1702 => 'mm-mine.png' ];
			foreach( $outposts AS &$outpost ) {
				$coords_nw = Livemap::geoid2pixelpos( $outpost['GeoDataID'] );
				$outpost['center_x'] = $coords_nw[0];
				$outpost['center_y'] = $coords_nw[1];
				$outpost['x'] = $coords_nw[0] - 8;
				$outpost['y'] = $coords_nw[1] - 8;
				$outpost['icon'] = $shapes[intval($outpost['ObjectTypeID'])];
				$outpost['type'] = $text['o' . $outpost['ObjectTypeID']];
			}
			
			foreach( $tradeposts AS &$tp ) {
				$coords_nw = Livemap::geoid2pixelpos( $tp['GeoDataID'] );
				$tp['center_x'] = $coords_nw[0];
				$tp['center_y'] = $coords_nw[1];
				$tp['x'] = $coords_nw[0] - 8;
				$tp['y'] = $coords_nw[1] - 8;
			}
			
			// Assign guild and claim data
			$content->assign( 'claims', $claims );
			$content->assign( 'pclaims', $pclaims );
			$content->assign( 'aclaims', $aclaims );
			$content->assign( 'outposts', $outposts );
			$content->assign( 'tradeposts', $tradeposts );
			$content->assign( 'json_claims', json_encode($claims_js) );
			$content->assign( 'json_standings', json_encode($standings) );
			$content->assign( 'json_outposts', json_encode($outposts) );
			
			// Use configured background color on livemap page
			$bgcolor = $config['color_bg'];
	
		break;
		
	}
	
	############################################################################################################################################
	#
	#  Fill main template
	#

	// Assign content
	$html->assign( 'CONTENT', $content->parse() );
	
	// Assign environment config
	$html->assign( 'VERSION', VERSION );
	$html->assign( 'BASE_URL', BASE_URL );
	$html->assign( 'LIVEMAP_ID', $livemap_id );
	$html->assign( 'TERRATOOL', $config['isttmap'] );
	$html->assign( 'REAL_LINK', ( isSet($_SERVER['HTTPS']) ? "https" : "http" ) . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]" );
	$html->assign( 'TABULATOR', isSet($include_tabulator) );
	
	// Assign user status and group privileges
	foreach( $mygroup->privileges AS $key => $bool ) $html->assign( "PRIV_$key", $bool );
	$html->assign( 'LOGGED_IN', $_SESSION['login'] );
	$html->assign( 'STEAM_AUTH', isSet($_SESSION['SteamAuth']) );
	$html->assign( 'PRIV_conf', $mygroup->admin );
	$html->assign( 'SHOW_CONTROLS', ($site === 'main') );
	
	// Assign fonts
	Livemap::load_font( $config['font_claimlabel'] );
	$html->assign( 'font_claimlabel', $config['font_claimlabel'] );
	Livemap::load_font( $config['font_claimdetail'] );
	$html->assign( 'font_claimdetail', $config['font_claimdetail'] );
	Livemap::load_font( 'Source Sans Pro' );
	$html->assign( 'FONTS_IMPORT', Livemap::$fonts_imported );
	
	// Assign visual config and details	
	$html->assign( 'MAP_FILE', $config['mapfile_default'] );
	$html->assign( 'MAP_FILE_ALT', $config['mapfile_alternative'] );
	$html->assign( 'WEB_LINK', $config['homepage'] );
	$html->assign( 'HAS_LINK', ( (bool)$config['homepage'] && ! $_SESSION['login'] ) );
	$html->assign( 'DISCORD', $config['discord'] );
	$html->assign( 'HAS_DISCORD', ( $config['discord'] && ! $_SESSION['login'] ) );
	$html->assign( 'DISCORD', $config['discord'] );
	$html->assign( 'HAS_DISCORD', ( $config['discord'] && ! $_SESSION['login'] ) );
	$html->assign( 'TEAMSPEAK', $config['teamspeak'] );
	$html->assign( 'HAS_TEAMSPEAK', ( $config['teamspeak'] && ! $_SESSION['login'] ) );
	$html->assign( 'HAS_GUILDMAN', (bool)intval($config['guildmanager']) );
	$html->assign( 'WEB_TITLE', htmlspecialchars($config['title']) );
	$html->assign( 'ENABLE_ALTMAP', (bool)intval($config['alt_map']) );
	$html->assign( 'IS_PUBLIC', (bool)$config['server_query'] );
	$html->assign( 'MOD_INSTALLED', $server->detect_servermod() );
	$html->assign( 'PLAYERS_ENABLE', ($server->detect_servermod() || (bool)intval($config['server_query'])) );
	$html->assign( 'HAS_LAYERS', ($mygroup->privileges['player_layer'] || $mygroup->privileges['road_layer'] || $mygroup->privileges['struct_layer']) );
	
	// Online players list
	$online_list = $mygroup->privileges['player_layer'] || $mygroup->privileges['online_list'] ? $server->get_online_players($mygroup->privileges['player_layer']) : array();
	$html->assign( 'PLAYERS', json_encode($online_list) );
	
	// Calculate next restart timers
	$restarts = $server->get_restart_timestamps($config['restarts']);
	$en_resta = $config['restarts'] ? TRUE : FALSE;
	$temp = explode( " " , $config['restarts'] );
	$restarts_string = "";
	foreach( $temp AS $i => $uts ) {
		switch( Livemap::$language ) {
			case 'de':	$rstring = "um " . date('H:i', strtotime($uts)) . " Uhr";	break;
			case 'fr':	$rstring = "á " . date('H\hi', strtotime($uts)) . " heure";	break;
			case 'ru':	$rstring = "в " . date('H:i', strtotime($uts)) . " МСК";	break;
			default:	$rstring = "at " . date('H:i', strtotime($uts));			break;
		}
		$restarts_string .= "<li>$rstring</li>";
	}
	$html->assign( 'restarts_string', $restarts_string );
	$html->assign( 'EN_RESTARTS', $en_resta );
	$html->assign( 'NEXT_RESTARTS', json_encode($restarts) );
	
	$html->assign( 'WIDTH_GCLAIM', $config['width_claim'] );
	$html->assign( 'STYLE_GCLAIM', $config['style_claim'] );
	$html->assign( 'STYLE_TOOLTP', $config['style_tooltip'] );
	$bgcolor = $site === 'main' ? $config['color_bg'] : '293134';
	$html->assign( 'COLOR_BACKGR', $bgcolor );
	$html->assign( 'COLOR_GLABEL', $config['color_label'] );
	$html->assign( 'SHOW_LABELS', ($config['color_label'] !== 'ZZZZZZ') );
	$html->assign( 'COLOR_GCLAIM_T1', $config['color_claim_t1'] );
	$html->assign( 'COLOR_GCLAIM_T1_RGB', hex2rgb($config['color_claim_t1']) );
	$html->assign( 'COLOR_GCLAIM_T2', $config['color_claim_t2'] );
	$html->assign( 'COLOR_GCLAIM_T2_RGB', hex2rgb($config['color_claim_t2']) );
	$html->assign( 'COLOR_GCLAIM_T3', $config['color_claim_t3'] );
	$html->assign( 'COLOR_GCLAIM_T3_RGB', hex2rgb($config['color_claim_t3']) );
	$html->assign( 'COLOR_GCLAIM_T4', $config['color_claim_t4'] );
	$html->assign( 'COLOR_GCLAIM_T4_RGB', hex2rgb($config['color_claim_t4']) );
	
	// Get weather info
	$weather = array();
	if( $mygroup->privileges['weather_now'] || $mygroup->privileges['weather_fc'] ) {
		$forecast = $mygroup->privileges['weather_fc'] ? 9 : 3;
		$gameday = $server->get_day( floatval($config['daycycle']) );
		$weather = $server->get_weather_array( $gameday, $gameday + $forecast );
		$html->assign( 'weather_now', $text[$weather[0]['weather']] );
		$html->assign( 'weather_tomorrow', $text[$weather[1]['weather']] );
		$html->assign( 'weather_icon', $weather[0]['weather'] );
	}
	
	// Assign javascript site config
	$site_config = array(
		'hasMap' => ( $site === 'main' ),
		'dayCycle' => floatval($config['daycycle']),
		'weatherInfo' => $weather,
		'defaultMap' => $config['mapfile_default'],
		'alternativeMap' => $config['mapfile_alternative'],
		'altMapEnabled' => (bool)intval($config['alt_map']),
		'showStandings' => $mygroup->privileges['standings']
	);
	$html->assign( 'SITE_CONFIG', json_encode($site_config) );
	
	// Message handling
	$html->assign( 'SHOW_MESSAGE', isSet($_SESSION['MSG']) );
	if( isSet($_SESSION['MSG']) ) {
		$html->assign( 'MESSAGE', $_SESSION['MSG']['text'] );
		if( isSet($_SESSION['MSG']['type']) ) $html->assign( 'MSG_SUCCESS', (bool)$_SESSION['MSG']['type'] );
		unset($_SESSION['MSG']);
	}
	
	// Assign translations and day names
	foreach( $text AS $key => $value ) $html->assign( "text_$key", $value );
	$html->assign( 'TEXT_JSON', json_encode($text) );
	$html->assign( 'DAY_JSON', json_encode($daynames) );
	
	// Print page
	print $html->parse();

?>