<?php

	/*
	 *	LiF:YO Livemap
	 *	http://nyuton.net
	 *
	 *	This program is free software: you can redistribute it and/or modify
	 *	it under the terms of the GNU General Public License as published by
	 *	the Free Software Foundation, either version 3 of the License, or
	 *	(at your option) any later version.
	 *
	 *	This program is distributed in the hope that it will be useful,
	 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
	 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	 *	GNU General Public License for more details.
	 *
	 *	You should have received a copy of the GNU General Public License
	 *	along with this program.  If not, see <https://www.gnu.org/licenses/>.
	 */
	 
	if( version_compare(PHP_VERSION, "5.4.0", "<") ) die("<u>Fatal Error</u><br>Your PHP version does not match the minimum requirement.<br>Minimum Version: <b>5.4.0</b><br>Your Version: <b>" . PHP_VERSION . "</b>");
	 
	const VERSION  = '2.7.2';
	const REVISION = 9;
	const BASE_URL = '/';
	$livemap_id = 1;
	
	require_once('includes/group.class.php');
	require_once('includes/mysql.class.php');
	require_once('config-dedicated.php');
	
	session_start();
	
	if( PHP_INT_SIZE === 4 && ! extension_loaded("gmp") && strtolower(QUERY_SERVER) === 'yes' ) die("<u>Fatal Error</u><br>Unsupported 32-Bit PHP version detected.<br>Use 64-Bit PHP or activate the php_gmp extension in your php.ini configuration file or turn off QUERY_SERVER setting in config-dedicated.inc.php");
	
	if( isSet($_POST['ajax']) && isSet($_SESSION['config']) && intval($_SESSION['config']['ID']) === $livemap_id ) {
		$config = $_SESSION['config'];
		$groups = $_SESSION['groups'];
	}
	
	$cdb = new MySQL( MYSQL_USER, MYSQL_PASS, MYSQL_DBSE, MYSQL_HOST, intval(MYSQL_PORT) );
	
	if( ! isSet($config['version']) || $config['version'] !== VERSION || isSet($_SESSION['force_reload']) ) {
		
		if( ! isSet($_SESSION['config']['version']) || $_SESSION['config']['version'] !== VERSION ) $_SESSION['login'] = FALSE;
		
		try{
			if( $cdb->table_exists('nyu_livemap') ) {			
				$config = $cdb->query( "SELECT * FROM nyu_livemap WHERE ID = '$livemap_id'", FALSE );
				if( ! $config ) $config = array( 'script_revision' => 0 );
				else $groups = $cdb->query( "SELECT * FROM nyu_livemap_groups WHERE livemap_id = '$livemap_id' ORDER BY ID ASC" );
			} else {
				$config = array( 'script_revision' => 0 );
			}
		} catch(Exception $e) { 
			die("<b>Failed to connect to the database.</b><br>Error {$e->code}: {$e->message}");
		}
				
		if( intval($config['script_revision']) < REVISION ) require_once('includes/updater.php');
		
		$config['path'] = dirname(__FILE__);
		$config['version'] = VERSION;
		$config['isttmap'] = FALSE;
		$config['game_ip'] = GAMESERVER_IP;
		$config['game_port'] = intval(GAMESERVER_PORT);
		$config['db_ip']   = MYSQL_HOST;
		$config['db_port'] = intval(MYSQL_PORT);
		$config['db_user'] = MYSQL_USER;
		$config['db_pass'] = MYSQL_PASS;
		$config['db_name'] = MYSQL_DBSE;
		$config['table_c'] = 'nyu_livemap';
		$config['table_g'] = 'nyu_livemap_groups';
		$config['table_s'] = 'nyu_livemap_sessions';
		$config['table_l'] = 'nyu_livemap_log';
		$config['server_query'] = strtolower(QUERY_SERVER) === 'yes' ? '1' : '0';
		$config['mapfile_default'] = 'maps/default.jpg';
		$config['mapfile_alternative'] = 'maps/alternative.jpg';
		$config['admin_pass'] = hash('sha256', ADMIN_PASS);

		$_SESSION['config'] = $config;
		$_SESSION['groups'] = $groups;
		
		unset($_SESSION['force_reload']);
		
	}

	require_once('main.php');

?>