// Dialog autofocus fix
//$.ui.dialog.prototype._focusTabbable = $.noop;

// Pad a number
Number.prototype.pad = function(size) {
	var s = String(this);
	while (s.length < (size || 2)) {s = "0" + s;}
	return s;
}

// Replace quotes in strign w/ entities
function killQuotes( str ) {
	return String(str).replace(/"/g, '&quot;').replace(/'/g, '&apos;');
}

// Start interval to refresh player count
function startInterval( target, interval ) {
	setInterval( function() { target(); }, interval );	// Start schedule
	target();											// Execute once on load
}

// Set cookie
function setCookie(cname, cvalue, exdays) {
    var d = new Date();
    d.setTime(d.getTime() + (exdays*24*60*60*1000));
    var expires = "expires="+ d.toUTCString();
    document.cookie = cname + "=" + cvalue + ";" + expires + ";path=/";
}

// Get cookie
function getCookie(cname) {
    var name = cname + "=";
    var ca = document.cookie.split(';');
    for(var i = 0; i < ca.length; i++) {
        var c = ca[i];
        while (c.charAt(0)==' ') c = c.substring(1);
        if (c.indexOf(name) == 0) return c.substring(name.length,c.length);
    }
    return "";
}

// Replace element with loader animation
function replaceWithWideLoader(element) {
	var loaderAnimationGif = new Image();
	loaderAnimationGif.src = 'img/ajax-loader-wide.gif';
	element.parentNode.insertBefore(loaderAnimationGif, element);
	element.style.display = 'none';
	return true;
}

// AJAX Communication
function ajax_send( data, callback ) {
	var xhr = new XMLHttpRequest();
	xhr.open( 'POST', 'index.php?livemap_id='+livemap_id, true );
	xhr.responseType = 'text';
	xhr.onload = function(e) {
		if( this.status == 200 ) {
			if( typeof(callback) !== 'undefined' ) callback( this.responseText );
		}
	};
	xhr.send( data );
}

// Geo functions
function geoid2pixelpos( GeoID ) {
	var TerID = parseInt(GeoID) >> 18;
	var TerX  = parseInt(GeoID) & ((1 << 9) - 1);
	var TerY  = (parseInt(GeoID) >> 9) & ((1 << 9) - 1);
	return terpos2pixelpos(TerID, TerX, TerY);
}

function terpos2pixelpos( TerID, TerX, TerY ) {
	switch( TerID ) {
		case 442:
		case 443:
		case 444:	var y = 1532 - TerY;	break;
		case 445:
		case 446:
		case 447:	var y = 1021 - TerY;	break;
		case 448:
		case 449:
		case 450:	var y = 510 - TerY;		break;
	}
	switch( TerID ) {
		case 443:	
		case 446:	
		case 449:	var x = TerX + 511;		break;
		case 444:	
		case 447:	
		case 450:	var x = TerX + 1022;	break;
		default:	var x = TerX;
	}
	return {x:x,y:y};
}